import path from 'path'
import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue2'
import mkcert from 'vite-plugin-mkcert'

export default defineConfig({
  plugins: [vue(), mkcert()],
  server: {
    open: true,
    host: 'dev.ezijing.com',
  },
  build: {
    outDir: 'client-dist',
  },
  resolve: {
    alias: [{ find: '@', replacement: path.resolve(__dirname, 'src') }],
  },
  css: {
    // 禁用SASS警告提醒
    preprocessorOptions: {
      scss: {
        quietDeps: true,
        charset: false,
        silenceDeprecations: ['import'],
      },
    },
  },
})
