/**
 * 申请声明
 */

export default function(_this) {
  return {
    id: 'application_declare',
    // title: '申请声明',
    title: _this.$t('application.declarationOfApplication'),
    visible() {
      return _this.visible
    },
    get: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}`,
      callback(data) {
        const { submission_stage: submissionStage = 'FILLING' } = data.data.material
        const isSubmited = submissionStage !== 'FILLING'
        this.form.options.disabled = isSubmited
        if (isSubmited) {
          return { isAgree: [1] }
        }
        return { isAgree: [] }
      }
    },
    update: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/submit/${process.env.projectId}`,
      callback() {
        _this.getApplication()
        this.form.options.disabled = true
        _this.$router.push({ path: this.$route.path, query: { active: 'application_pay' } })
      },
      errorCallback() {
        _this.completeVisible = true
      }
    },
    form: {
      prev: { to: { query: { active: 'application_tjx' } } },
      submitText: _this.$t('application.submitAnApplication'),
      model: { isAgree: [] },
      options: {},
      items: [
        {
          type: 'v-checkbox',
          values: [{ label: '同意', value: 1 }],
          model: 'isAgree',
          rules: [{ required: true, message: '请阅读协议', trigger: 'change' }],
          prepend: `<p>${_this.$t('application.declare')}</p>`
        }
      ]
    }
  }
}
