/**
 * 教育背景
 */

export default function(_this) {
  return {
    id: 'application_info_education',
    // title: '教育背景',
    title: _this.$t('application.education'),
    required: true,
    visible() {
      return _this.visible
    },
    get: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}`,
      callback(data) {
        const { educations: list = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
        this.form.options.disabled = submissionStage !== 'FILLING'
        return list.length ? list : [{}]
      }
    },
    update: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}/put`,
      beforeRequest(data) {
        const educations = data.map(item => {
          return ['start_date', 'end_date', 'school_name_cn', 'major_cn', 'degree'].reduce((result, key) => {
            result[key] = item[key]
            return result
          }, {})
        })
        return { educations }
      }
    },
    form: {
      prev: { to: { query: { active: 'application_info', tab: 'application_info_profile' } }, isSubmit: true },
      next: { to: { query: { active: 'application_info', tab: 'application_info_career' } }, isSubmit: true },
      hasAdd: true,
      options: { labelWidth: '140px' },
      items: [
        {
          type: 'v-datepicker',
          label: _this.$t('application.startTime'),

          model: 'start_date',
          attrs: {
            type: 'month',
            placeholder: '请选择教育开始时间',
            valueFormat: 'yyyy-MM'
          },
          rules: [{ required: true, message: '请选择教育开始时间', trigger: 'blur' }]
        },
        {
          type: 'v-datepicker',
          label: _this.$t('application.finishTime'),

          model: 'end_date',
          attrs: {
            type: 'month',
            placeholder: '请选择教育结束时间',
            valueFormat: 'yyyy-MM'
          },
          rules: [{ required: true, message: '请选择教育结束时间', trigger: 'blur' }]
        },
        {
          type: 'v-input',
          label: _this.$t('application.institution'),

          model: 'school_name_cn',
          attrs: { placeholder: '请输入学校名称' },
          rules: [{ required: true, message: '请输入学校名称', trigger: 'blur' }]
        },
        {
          type: 'v-input',
          label: '专业名称',
          model: 'major_cn',
          label: _this.$t('application.majorName'),

          rules: [{ required: true, message: '请输入专业名称', trigger: 'blur' }]
        },
        {
          type: 'v-select',
          values: [
            { value: '专科', label: _this.$t('application.degree1') },
            { value: '本科', label: _this.$t('application.degree2') },
            { value: '本科/学士', label: _this.$t('application.degree3') },
            { value: '硕士研究生', label: _this.$t('application.degree4') },
            { value: '研究生/硕士', label: _this.$t('application.degree5') },
            { value: '博士研究生', label: _this.$t('application.degree6') },
            { value: '研究生/博士', label: _this.$t('application.degree7') },
            { value: '其他', label: _this.$t('application.degree8') }
          ],
          label: _this.$t('application.degree'),
          model: 'degree',
          rules: [{ required: true, message: '请选择学历/学位', trigger: 'change' }]
        }
      ]
    }
  }
}
