/**
 * 所受培训
 */

export default function(_this) {
  return {
    id: 'application_info_training',
    // title: '所受培训',
    title: _this.$t('application.training'),
    visible() {
      return _this.visible
    },
    get: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}`,
      callback(data) {
        const { trainings: list = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
        this.form.options.disabled = submissionStage !== 'FILLING'
        return list.length ? list : [{}]
      }
    },
    update: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}/put`,
      beforeRequest(data) {
        const trainings = data.map(item => {
          return ['start_date', 'end_date', 'institution_cn', 'course_cn'].reduce((result, key) => {
            result[key] = item[key] || ''
            return result
          }, {})
        })
        return { trainings }
      }
    },
    form: {
      prev: { to: { query: { active: 'application_info', tab: 'application_info_answer' } }, isSubmit: true },
      next: { to: { query: { active: 'application_info', tab: 'application_info_honor' } }, isSubmit: true },
      hasAdd: true,
      options: { labelWidth: '140px' },
      items: [
        {
          type: 'v-datepicker',
          label: _this.$t('application.startTime'),
          model: 'start_date',
          attrs: {
            type: 'month',
            placeholder: '请选择培训开始时间',
            valueFormat: 'yyyy-MM'
          }
          // rules: [{ required: true, message: '请选择培训开始时间', trigger: 'blur' }]
        },
        {
          type: 'v-datepicker',
          label: _this.$t('application.finishTime'),
          model: 'end_date',
          attrs: {
            type: 'month',
            placeholder: '请选择培训结束时间',
            valueFormat: 'yyyy-MM'
          }
          // rules: [{ required: true, message: '请选择培训结束时间', trigger: 'blur' }]
        },
        {
          type: 'v-input',
          label: _this.$t('application.trainingInstitution'),
          model: 'institution_cn',
          attrs: { placeholder: '请输入培训机构' }
          // rules: [{ required: true, message: '请输入培训机构', trigger: 'blur' }]
        },
        {
          type: 'v-input',
          label: _this.$t('application.courseName'),
          model: 'course_cn',
          attrs: { placeholder: '请输入课程名称' }
          // rules: [{ required: true, message: '请输入课程名称', trigger: 'blur' }]
        }
      ]
    }
  }
}
