export default function(_this) {
  return {
    id: 'interview_zp',
    // title: '2寸照片',
    title: _this.$t('application.twoInchPhoto'),
    get: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}`,
      callback(data) {
        const { attachments = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
        const stageList = ['FILLING', 'PREPAYMENT', 'INTERVIEW_APPLICATION', 'AUDITION', 'INTERVIEW', 'PAYMENT', 'REGISTRATION', 'CLOSED']
        this.form.options.disabled = stageList.findIndex(item => item === submissionStage) > 2
        const PERSONAL_PHOTO_FOR_ID = attachments.filter(item => {
          return item.file_type_id === 'PERSONAL_PHOTO_FOR_ID'
        })
        return { PERSONAL_PHOTO_FOR_ID }
      }
    },
    update: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/submit/${process.env.projectId}`,
      beforeRequest(data) {
        return { submission_stage: 'INTERVIEW_APPLICATION' }
      },
      callback() {
        this.form.options.disabled = true
        _this.dialogVisible = true
        _this.getApplication()
      },
      errorCallback() {
        _this.completeVisible = true
      }
    },
    form: {
      prev: { to: { query: { active: 'interview_cjd' } } },
      submitText: _this.$t('application.admissionInterview'),
      model: { submission_stage: 'INTERVIEW_APPLICATION' },
      options: {},
      items: [
        {
          type: 'v-upload',
          model: 'PERSONAL_PHOTO_FOR_ID',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'PERSONAL_PHOTO_FOR_ID' }
          },
          prepend: _this.$t('application.twoInchPhotoNote1'),
          append: _this.$t('application.twoInchPhotoNote2')
        }
      ]
    }
  }
}
