// let config = {}
// if (process.env.NODE_ENV === 'production') {
//   config = {
//     server: { port: 2047, host: '0.0.0.0', timing: false }
//   }
// }
import path from 'path'
import fs from 'fs'
export default {
  env: process.env,
  server: { port: 2048, host: '0.0.0.0' },
  // ...(process.env.NODE_ENV === 'development' && {
  //   server: {
  //     host: 'dev.ezijing.com',
  //     https: {
  //       key: fs.readFileSync(path.resolve(__dirname, 'dev.ezijing.com.key')),
  //       cert: fs.readFileSync(path.resolve(__dirname, 'dev.ezijing.com.pem'))
  //     }
  //   }
  // }),
  // Global page headers: https://go.nuxtjs.dev/config-head
  head: {
    title: '紫荆教育-在线学位，国际留学，数字经济产业学院',
    htmlAttrs: {
      lang: 'en'
    },
    meta: [
      { charset: 'utf-8' },
      {
        name: 'viewport',
        content: 'width=device-width, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0, viewport-fit=cover'
      },
      {
        name: 'keywords',
        content:
          '工商管理硕士,MBA硕士,免联考MBA,国际MBA,通用MBA,在职MBA,在线MBA,MBA,美国MBA,教育学硕士,金融硕士,心理学硕士,应用心理学硕士,在职心理学硕士,国际教育学硕士,在职金融硕士,在线心理学硕士,在职教育学硕士,国际金融硕士,美国教育学硕士,在职应用心理学硕士,教育学硕士学位,美国心理学硕士,在职工商管理硕士,酒店管理硕士,在职酒店管理硕士,理财规划师,企业理财顾问师,投资理财顾问,金融理财师,理财培训,企业融资,国家理财规划师,财富管理,资产管理,个人财富管理,证券投资,信托投资,房地产投资'
      },
      {
        name: 'description',
        content:
          '紫荆教育全称是清控紫荆（北京）教育科技股份有限公司，是2015年以清华大学五道口金融学院相关知识产权创设而成。提供国际在线学位教育、国际留学、数字经济产业学院整体解决方案等产品服务，为各行各业培养和输送高质量的国际化和产业化人才'
      }
    ],
    link: [
      {
        rel: 'icon',
        type: 'image/x-icon',
        href: 'https://zws-imgs-pub.ezijing.com/static/public/f56441ae1441902080226712d4d650aa.ico'
      }
    ]
  },

  // Global CSS: https://go.nuxtjs.dev/config-css
  css: ['vant/lib/index.css', 'swiper/css/swiper.css', '@/assets/css/base.css', 'element-ui/lib/theme-chalk/index.css'],

  // Plugins to run before rendering page: https://go.nuxtjs.dev/config-plugins
  plugins: ['@/plugins/i18n', '@/plugins/axios', '@/plugins/vant', '@/plugins/element-ui', { src: '@/plugins/swiper' }],

  // Auto import components: https://go.nuxtjs.dev/config-components
  components: true,

  // Modules for dev and build (recommended): https://go.nuxtjs.dev/config-modules
  buildModules: [],

  // Modules: https://go.nuxtjs.dev/config-modules
  modules: ['@nuxtjs/axios', 'cookie-universal-nuxt'],

  // Build Configuration: https://go.nuxtjs.dev/config-build
  build: {},
  router: {
    middleware: ['i18n', 'route']
  }
}
