// https://nuxt.com/docs/api/configuration/nuxt-config
export default defineNuxtConfig({
  devServer: {
    host: 'dev.ezijing.com',
    https: { key: './dev.ezijing.com-key.pem', cert: './dev.ezijing.com.pem' },
  },
  compatibilityDate: '2025-07-15',
  devtools: { enabled: false },
  modules: ['@nuxtjs/i18n', '@element-plus/nuxt'],
  elementPlus: { importStyle: 'scss', themeChalk: { $colors: { primary: { base: '#a81840' } } } },
  i18n: {
    strategy: 'no_prefix',
    locales: [
      { code: 'zh', file: 'zh-CN.js', name: '中文' },
      { code: 'en', file: 'en-US.js', name: 'English' },
    ],
    defaultLocale: 'zh',
    compilation: { strictMessage: false },
    detectBrowserLanguage: {
      useCookie: true,
      cookieKey: 'i18n_locale',
      fallbackLocale: 'zh',
    },
  },
  runtimeConfig: {
    public: {
      projectId: '6800242743894343680',
      baseURL: 'https://project-api.ezijing.com',
      loginURL: 'https://login.ezijing.com/auth',
    },
  },
  css: ['assets/css/base.css', 'swiper/css', 'swiper/css/navigation', 'swiper/css/pagination'],
  app: {
    head: {
      title: '清控紫荆教育-AI 产教融合新基建、在线学位、海外名校硕士保研',
      htmlAttrs: {
        lang: 'zh',
      },
      meta: [
        { charset: 'utf-8' },
        { name: 'viewport', id: 'viewport', content: 'initial-scale=-1,maximum-scale=1,shrink-to-fit=no' },
        {
          name: 'keywords',
          content:
            '工商管理硕士,MBA硕士,免联考MBA,国际MBA,通用MBA,在职MBA,在线MBA,MBA,美国MBA,金融硕士,金融硕士,心理学硕士,应用心理学硕士,在职心理学硕士,国际金融硕士,在职金融硕士,在线心理学硕士,在职金融硕士,国际金融硕士,美国金融硕士,在职应用心理学硕士,金融硕士学位,美国心理学硕士,在职工商管理硕士,酒店管理硕士,在职酒店管理硕士,理财规划师,企业理财顾问师,投资理财顾问,金融理财师,理财培训,企业融资,国家理财规划师,财富管理,资产管理,个人财富管理,证券投资,信托投资,私人财富风险管理顾问',
        },
        {
          name: 'description',
          content:
            '紫荆教育全称是清控紫荆（北京）教育科技股份有限公司，是2015年以清华大学五道口金融学院相关知识产权创设而成。提供国际在线学位教育、国际留学、数字经济产业学院整体解决方案等产品服务，为各行各业培养和输送高质量的国际化和产业化人才',
        },
      ],
      link: [
        {
          rel: 'icon',
          type: 'image/x-icon',
          href: 'https://zws-imgs-pub.ezijing.com/static/public/f56441ae1441902080226712d4d650aa.ico',
        },
      ],
    },
  },
})
