// Nuxt 4 middleware - 设备检测和移动端重定向
export default defineNuxtRouteMiddleware((to, from) => {
  // 获取 User-Agent
  const headers = useRequestHeaders()
  const userAgent = process.server ? headers['user-agent'] || '' : navigator.userAgent

  // 检测是否为移动设备
  const isMobile = /iphone/i.test(userAgent) || (/android/i.test(userAgent) && /mobile/i.test(userAgent))

  // 如果是移动设备，重定向到移动端网站
  if (isMobile) {
    const redirectUrl = `https://h5.ezijing.com${to.fullPath}`

    if (process.server) {
      // 服务端使用 301 重定向
      return navigateTo(redirectUrl, { redirectCode: 301, external: true })
    } else {
      // 客户端使用 window.location
      window.location.href = redirectUrl
      return abortNavigation()
    }
  }
})
