// Nuxt 4 middleware - 路由重定向
export default defineNuxtRouteMiddleware((to, from) => {
  // 定义路由重定向映射
  const redirectMap = {
    '/sofia': 'https://sofia.ezijing.com',
    '/kelley': 'https://kelley.ezijing.com',
    '/marywood': 'https://marywood.ezijing.com',
    '/ciis': 'https://ciis.ezijing.com',
    '/cu': 'https://cu.ezijing.com',
    '/shms': 'https://shms.ezijing.com',
  }

  // 检查路由是否需要重定向
  for (const [path, url] of Object.entries(redirectMap)) {
    if (to.path.startsWith(path)) {
      if (process.server) {
        // 服务端使用 301 重定向
        return navigateTo(url, { redirectCode: 301, external: true })
      } else {
        // 客户端使用 window.location
        window.location.href = url
        return abortNavigation()
      }
    }
  }
})


