import httpRequest from '@/utils/httpRequest'

// 获取广告列表
export function getAdvertisementList(params) {
  return httpRequest.get('/api/cms/api/v1/advertisements', { params })
}

// 获取新闻列表
export function getNewsList(params) {
  return httpRequest.get(`/api/zws/v1/cms/news`, { params })
}

// 获取新闻详情
export function getNewsDetails(params) {
  return httpRequest.get(`/api/zws/v1/cms/new`, { params })
}

/**
 * 发送验证码
 */
export function sendCode(data) {
  return httpRequest.post('/api/usercenter/user/send-code', data, {
    headers: { 'Content-Type': 'multipart/form-data' },
  })
}

/**
 * 检验验证码
 */
export function checkCode(params) {
  return httpRequest.get('/api/usercenter/user/check-code', { params })
}

/**
 * 提交留咨信息
 */
export function postNes(data) {
  return httpRequest.post('/api/enrollment/v1.0/applications', data, {
    headers: { 'Content-Type': 'multipart/form-data' },
  })
}

/**
 * 获取文章列表
 */
export function getArticleList(params) {
  return httpRequest.get('/api/cms/api/v1/articles', { params })
}

/**
 * 获取图文列表
 */
export function getImgTextList(params) {
  return httpRequest.get('/api/cms/api/v1/img-text', { params })
}

// 提交留咨信息
export function submitApplicationForm(data) {
  return httpRequest.post('/api/enrollment/v1.0/applications', data)
}
