#!/bin/bash

IMAGEVERSION=1.0.0

function docker_pro () {
  export APPNAME=project-www-pc
  export IMAGE=registry.cn-beijing.aliyuncs.com/ezijing-beijing/$APPNAME:$IMAGEVERSION
  export IMAGE_VPC=registry.cn-beijing.aliyuncs.com/ezijing-beijing/$APPNAME:$IMAGEVERSION
  old_git_commit_id=`cat git_commit.id`
  new_git_commit_id=`git log | awk '/commit(.*)$/ { print $2;exit; }'`
  if [ "$new_git_commit_id" != "$old_git_commit_id" ]; then
    # n 14.19.0 && npm install && npm run build
    sudo docker build ./ -t $IMAGE
    sudo docker push $IMAGE
    sudo docker rmi $IMAGE
  fi
  echo $new_git_commit_id > git_commit.id
  # 提前 服务器上配置 config-pro 和 config-test 文件，并kubectl指令可用
  export NAMESPACE=kube-node-lease
  export DOMAIN=www-inside
  export DOMAIN1=pc-inside
  declare -x KUBECONFIG=~/.kube/config-pro-k8s-01
  # kubectl get pod `kubectl get pods --namespace=$NAMESPACE -l app=$APPNAME | awk 'NR!=1 { print $1 }'` -n $NAMESPACE -o yaml | kubectl replace --force -f -
  envsubst < k8s.yml | kubectl apply -f -
}

function docker_pre () {
  export APPNAME=project-www-pc-pre
  export IMAGE=registry.cn-beijing.aliyuncs.com/ezijing-beijing/$APPNAME:$IMAGEVERSION
  export IMAGE_VPC=registry-vpc.cn-beijing.aliyuncs.com/ezijing-beijing/$APPNAME:$IMAGEVERSION
  old_git_commit_id=`cat git_commit.id`
  new_git_commit_id=`git log | awk '/commit(.*)$/ { print $2;exit; }'`
  if [ "$new_git_commit_id" != "$old_git_commit_id" ]; then
    n 16.13.2 && npm install && npm run build:pre
    sudo docker build ./ -t $IMAGE
    sudo docker push $IMAGE
    sudo docker rmi $IMAGE
  fi
  echo $new_git_commit_id > git_commit.id
  # 提前 服务器上配置 config-pro 和 config-test 文件，并kubectl指令可用
  export NAMESPACE=ezijing-web-pre
  export DOMAIN=www
  export DOMAIN1=pc
  declare -x KUBECONFIG=~/.kube/config-test
  # kubectl get pod `kubectl get pods --namespace=$NAMESPACE -l app=$APPNAME | awk 'NR!=1 { print $1 }'` -n $NAMESPACE -o yaml | kubectl replace --force -f -
  envsubst < k8s.yml | kubectl apply -f -
}

function docker_test () {
  export APPNAME=project-www-pc-test
  export IMAGE=registry.cn-beijing.aliyuncs.com/ezijing-beijing/$APPNAME:$IMAGEVERSION
  export IMAGE_VPC=registry-vpc.cn-beijing.aliyuncs.com/ezijing-beijing/$APPNAME:$IMAGEVERSION
  old_git_commit_id=`cat git_commit.id`
  new_git_commit_id=`git log | awk '/commit(.*)$/ { print $2;exit; }'`
  if [ "$new_git_commit_id" != "$old_git_commit_id" ]; then
    n 16.13.2 && npm install && npm run build:test
    sudo docker build ./ -t $IMAGE
    sudo docker push $IMAGE
    sudo docker rmi $IMAGE
  fi
  echo $new_git_commit_id > git_commit.id
  # 提前 服务器上配置 config-pro 和 config-test 文件，并kubectl指令可用
  export NAMESPACE=ezijing-web-test
  export DOMAIN=www2
  export DOMAIN1=pc2
  declare -x KUBECONFIG=~/.kube/config-test
  # kubectl get pod `kubectl get pods --namespace=$NAMESPACE -l app=$APPNAME | awk 'NR!=1 { print $1 }'` -n $NAMESPACE -o yaml | kubectl replace --force -f -
  envsubst < k8s.yml | kubectl apply -f -
}

# 执行指令
if [ "$1" == "" ]; then
  echo "$0 must enter param like (pro / pre / test)"
else
  if [ "$2" == "" ]; then
    echo "使用默认版本发布，版本号：$IMAGEVERSION"
  else
    IMAGEVERSION=$2
  fi
  export TIMESTAMP=`date +%s%3N`
  case "$1" in
    pro)
      docker_pro
      ;;
    pre)
      docker_pre
      ;;
    test)
      docker_test
      ;;
    *)
      echo $"Usage: $0 {pro/pre/test}"
      exit 1
  esac
fi
