import httpRequest from '@/utils/httpRequest'

// 获取广告列表
export function getAdvertisementList(params) {
  return httpRequest.get('/api/cms/api/v1/advertisements', { params })
}

/**
 * 获取文章列表
 */
export function getArticleList(params) {
  return httpRequest.get('/api/cms/api/v1/articles', { params })
}

/**
 * 获取图文列表
 */
export function getImgTextList(params) {
  return httpRequest.get('/api/cms/api/v1/img-text', { params })
}

// 提交留咨信息
export function submitApplicationForm(data) {
  return httpRequest.post('/api/enrollment/v1.0/applications', data)
}

/**
 * 获取用户信息
 */
export function getUser(params = { learning_info: 1 }) {
  return httpRequest.get('/api/usercenter/v2/frontend/user/get-user-info', { params })
}

/**
 * 修改用户信息
 */
export function updateUser(data) {
  return httpRequest.post('/api/usercenter/user/update-user', data)
}

/**
 * 修改密码
 */
export function updatePassword(data) {
  return httpRequest.post('/api/usercenter/user/update-pwd', data)
}

/**
 * 发送验证码
 */
export function sendCode(data) {
  return httpRequest.post('/api/usercenter/user/send-code', data)
}

/**
 * 检验验证码
 */
export function checkCode(params) {
  return httpRequest.get('/api/usercenter/user/check-code', { params })
}

/**
 * 退出登录
 */
export function logout() {
  return httpRequest.get('/api/passport/rest/logout')
}
