import type { Router, RouteRecordRaw } from 'vue-router'

export default function ({ router }: { router: Router }) {
  const modules: Array<{ routes: RouteRecordRaw[] }> = Object.values(import.meta.glob('./**/index.ts', { eager: true }))
  modules.forEach(module => {
    // 注册路由
    module.routes.forEach(route => router.addRoute(route))
  })
}
