import httpRequest from '@/utils/axios'
import type { TripTemplateListRequest, TripTemplateCreateRequest, TripTemplateUpdateRequest } from './types'

// 获取旅程模板列表
export function getTripTemplateList(params: TripTemplateListRequest) {
  return httpRequest.get('/api/lab/v1/experiment/itinerary/list', { params })
}

// 创建旅程模板
export function createTripTemplate(data: TripTemplateCreateRequest) {
  return httpRequest.post('/api/lab/v1/experiment/itinerary/create', data)
}

// 更新旅程模板
export function updateTripTemplate(data: TripTemplateUpdateRequest) {
  return httpRequest.post('/api/lab/v1/experiment/itinerary/update', data)
}

// 获取旅程连接
export function getTripConnections(params: { itinerary_id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/itinerary/connections', { params })
}

// 旅程绑定连接
export function bindTripConnections(data: { itinerary_id: string; connection_ids: string[] }) {
  return httpRequest.post('/api/lab/v1/experiment/itinerary/bind-connections', data)
}

// 获取旅程模板详情
export function getTripTemplate(params: { id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/itinerary/detail', { params })
}

// 获取旅程模板demo
export function getTripTemplateDemo(params: { itinerary_id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/itinerary/get-itinerary-demo', { params })
}

// 更新旅程模板demo
export function updateTripTemplateDemo(data: { itinerary_id: string; graph: string }) {
  return httpRequest.post('/api/lab/v1/experiment/itinerary/save-itinerary-demo', data)
}

// 获取实验数据规则配置
export function getRule(params: { itinerary_id: string }) {
  return httpRequest.get('/api/resource/v1/backend/experiment-itinerary/data-rule-detail', { params })
}

// 获取实验旅程检索用户的结果
export function ruleQuery(data: { experiment_id: string; filters: string }) {
  return httpRequest.post('/api/resource/v1/backend/experiment-itinerary/itinerary-query', data)
}

// 保存实验旅程数据规则
export function saveRule(data: {
  itinerary_id: string
  data_generate_mode: string
  data_generate_frequency: string
  auto_generate_rule: string
  graph: string
}) {
  return httpRequest.post('/api/resource/v1/backend/experiment-itinerary/save-data-config', data)
}

// 取消、触发旅程
export function updateTriggerStatus(data: { itinerary_id: string; trigger_status: 0 | 1 }) {
  return httpRequest.post('/api/lab/v1/experiment/itinerary/trigger', data)
}

// 获取配置旅程数据规则
export function getGenerateDataRule(params: { itinerary_id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/itinerary/generate-data-config', { params })
}

// 保存配置旅程数据规则
export function updateGenerateDataRule(data: { itinerary_id: string; config: any }) {
  return httpRequest.post('/api/lab/v1/experiment/itinerary/generate-data-config', data)
}
