export interface Dictionary {
  label: string
  value: string | number
}

export function getNameByValue(value: string | number, list: Dictionary[]) {
  return list.find((item) => item.value == value)?.label || value
}

// 旅程类型
export const tripTemplateTypeList = [
  { label: '自由旅程', value: '1' },
  { label: '固定旅程', value: '2' },
]

// 群组类型
export const groupTypeList = [
  { label: '静态群组', value: '1' },
  { label: '动态群组', value: '2' },
  { label: 'RFM群组', value: '3' },
]

// 更新方式
export const updateStatusRuleList = [
  { label: '自动更新', value: '1' },
  { label: '手动更新', value: '2' },
]

// 更新状态
export const updateStatusList = [
  { label: '未开始', value: '1' },
  { label: '进行中', value: '2' },
  { label: '完成', value: '3' },
  { label: '进行中', value: '4' },
]

export const dateUnitList = [
  { label: '天', value: 1 },
  { label: '周', value: 2 },
  { label: '月', value: 3 },
]

export const weekList = [
  { label: '周一', value: 1 },
  { label: '周二', value: 2 },
  { label: '周三', value: 3 },
  { label: '周四', value: 4 },
  { label: '周五', value: 5 },
  { label: '周六', value: 6 },
  { label: '周日', value: 7 },
]

export interface OperatorType {
  label: string
  value: string
  alias?: string
}

// 字符串
export const stringOperatorList: OperatorType[] = [
  { label: '等于', value: '=' },
  { label: '不等于', value: '!=' },
  { label: '包含', value: 'in' },
  { label: '不包含', value: 'not in' },
  { label: '空值', value: 'null' },
  { label: '非空', value: 'not null' },
]

// 整数|数字
export const numberOperatorList: OperatorType[] = [
  { label: '=', value: '=' },
  { label: '!=', value: '!=', alias: '≠' },
  { label: '>', value: '>' },
  { label: '>=', value: '>=', alias: '≥' },
  { label: '<', value: '<' },
  { label: '<=', value: '<=', alias: '≤' },
  { label: '区间', value: 'range' },
  { label: '空值', value: 'null' },
  { label: '非空', value: 'not null' },
]

// 日期
export const dateOperatorList: OperatorType[] = [
  { label: '绝对时间之前', value: 'before' },
  { label: '绝对时间之后', value: 'after' },
  { label: '绝对时间区间', value: 'range' },
  // { label: '相对过去天数', value: 'relative_past_day' },
  // { label: '相对当前天数', value: 'relative_current_day' },
  // { label: '在...天内', value: 'in_day' }
]

export const happenInfoList = [
  { label: '发生过', value: true },
  { label: '未发生过', value: false },
]

export const triggerInfoList = [{ label: '触发次数', value: '触发次数' }]

export const labelList = [
  { label: '单属性标签', value: '5' },
  { label: '多属性标签', value: '6' },
  { label: '事件偏好标签 ', value: '2' },
  { label: '事件指标标签 ', value: '3' },
  { label: '自定义标签', value: '7' },
  { label: '分层标签 ', value: '1' },
  { label: 'RFM模型标签 ', value: '4' },
]

export const wayList = [
  { label: '总金额 ', value: '1' },
  { label: '总次数 ', value: '2' },
  { label: '平均金额 ', value: '3' },
]

export const materialMethodList = [
  { label: '离线上传 ', value: '2' },
  { label: '在线AI', value: '1' },
  // { label: '在线设计', value: '3' },
  { label: 'AI图像生成', value: '3' },
]

// 使用场景
export const materialUsageList = [
  { label: '用户拉新 ', value: '1' },
  { label: '产品宣传 ', value: '2' },
  { label: '用户关怀 ', value: '3' },
  { label: '系统通知 ', value: '4' },
]

// 在线设计使用场景
export const materialDesignUsageList = [
  { label: '手机海报 ', value: '447' },
  { label: '公众号首图 ', value: '216' },
  { label: '小红书配图', value: '502' },
  { label: '每日一签', value: '209' },
  { label: '全屏海报', value: '581' },
  { label: '邀请函', value: '170' },
  { label: 'PPT16:9', value: '1' },
  { label: '简历', value: '38' },
  { label: '长图海报', value: '35' },
  { label: '公众号次图', value: '40' },
  { label: '主图图标', value: '503' },
  { label: '商品主图', value: '29' },
  { label: '名片', value: '12' },
  { label: '长页H5', value: '166' },
  { label: '直播贴片', value: '511' },
  { label: '视频海报', value: '498' },
  { label: '竖版直播背景', value: '572' },
  { label: '横版海报', value: '20' },
  { label: '竖版插画', value: '233' },
]

// 使用人员
export const materialUsersList = [
  { label: '销售人员 ', value: '1' },
  { label: '品牌人员 ', value: '2' },
  { label: '客服人员 ', value: '3' },
  { label: '运维人员 ', value: '4' },
  { label: '机器系统 ', value: '5' },
]

// 图片风格
export const materialPictureStyleList = [
  { label: '商务风格 ', value: '1' },
  { label: '扁平化 ', value: '2' },
  { label: '清新文艺 ', value: '3' },
  { label: '古典中国风 ', value: '4' },
  { label: '创意简约风 ', value: '5' },
  { label: '艺术插画 ', value: '6' },
  { label: '大气渐变 ', value: '7' },
  { label: '手绘水彩风 ', value: '8' },
  { label: '时尚杂志风 ', value: '9' },
  { label: '漫画风格 ', value: '10' },
]

// 文本用途
export const textPurposeList = [
  { label: '消息/短息', value: '1' },
  { label: '长文本/文章 ', value: '2' },
  { label: '短视频脚本 ', value: '3' },
]

// 直播时长
export const liveTestDuration = [
  { label: '10分钟', value: '10' },
  { label: '15分钟 ', value: '15' },
  { label: '20分钟 ', value: '20' },
]

// 直播时长
export const liveTestUploadWay = [
  { label: '实时上传', value: '1' },
  { label: '本地上传', value: '2' },
]

// 重要性
export const importType = [
  { label: '非重要', value: '0' },
  { label: '重要', value: '1' },
]

// 必要性
export const requiredType = [
  { label: '非必需', value: '0' },
  { label: '必需', value: '1' },
]

// 发货模式
export const deliveryMode = [
  { label: '现货发货模式', value: '1' },
  { label: '现货 + 预售发货模式', value: '2' },
]

// 发货时效
export const deliveryTime = [
  { label: '当日发/次日发', value: '1' },
  { label: '次日发', value: '2' },
  { label: '48小时内发货', value: '3' },
  { label: '3天内发货', value: '4' },
  { label: '5天内发货', value: '5' },
  { label: '7天内发货', value: '6' },
  { label: '10天内发货', value: '7' },
  { label: '15天内发货', value: '8' },
]

// 订单库存计数
export const orderStockCount = [
  { label: '下单减库存', value: '1' },
  { label: '付款减库存', value: '2' },
]

// 运费模板
export const shippingTemplate = [
  { label: '阶梯计价运费', value: '1' },
  { label: '固定运费', value: '2' },
  { label: '卖家包邮', value: '3' },
  { label: '指定条件包邮', value: '4' },
  { label: '限制买家下单区域', value: '5' },
  { label: '按件数计价', value: '6' },
  { label: '按重量计价', value: '7' },
  { label: '指定地区运费', value: '8' },
  { label: '指定地区禁止下单', value: '9' },
  { label: '全国包邮模板', value: '10' },
  { label: '自选快递运费模板', value: '11' },
  { label: '满99元包邮', value: '12' },
  { label: '全国包邮（偏远地区除外）', value: '13' },
]

// 售后政策
export const afterSalesPolicy = [
  { label: '7天无理由退换货', value: '1' },
  { label: '全额退款', value: '2' },
  { label: '仅退款政策', value: '3' },
  { label: '预付邮费标签', value: '4' },
  { label: '全球购物保障计划', value: '5' },
  { label: '无忧退换货', value: '6' },
  { label: '闪电退货', value: '7' },
  { label: '售后补寄', value: '8' },
  { label: '坏果包赔', value: '9' },
]
