import type { Operator } from '@/types'

export interface TripTemplate {
  id: string
  name: string
  type: string
  status: string
  score: string
  is_view_answer: string
  created_time: string
  created_operator: Operator
  updated_time: string
  updated_operator: Operator
}

export type TripTemplateListRequest = Pick<TripTemplate, 'name' | 'type' | 'status'> & { experiment_id?: string }

export type TripTemplateUpdateRequest = Pick<TripTemplate, 'id' | 'name' | 'type' | 'is_view_answer' | 'status'> & {
  experiment_id?: string
  score: number
}

export type TripTemplateCreateRequest = Omit<TripTemplateUpdateRequest, 'id'>
