import { getEventList } from '../api'

export interface EventType {
  id: string
  name: string
  english_name: string
}
const eventList = ref<EventType[]>([])
export function useEvent() {
  const eventValues = ref([])
  async function fetchEventList() {
    const res = await getEventList()
    eventList.value = res.data.items
  }
  onMounted(() => {
    // if (!eventList.value?.length) fetchEventList()
    fetchEventList()
  })
  return { fetchEventList, eventList, eventValues }
}
