import httpRequest from '@/utils/axios'
import type {
  GroupListRequest,
  StaticGroupCreateRequest,
  StaticGroupUpdateRequest,
  DynamicGroupCreateRequest,
  DynamicGroupUpdateRequest,
  RFMGroupCreateRequest,
  RFMGroupUpdateRequest
} from './types'

// 获取群组列表
export function getGroupList(params?: GroupListRequest) {
  return httpRequest.get('/api/lab/v1/experiment/group/bda-list', { params })
}

// 获取群组详情
export function getGroupInfo(params: { id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/group/bda-detail', { params })
}

// 创建静态群组
export function createStaticGroup(data: StaticGroupCreateRequest) {
  return httpRequest.post('/api/lab/v1/experiment/group/bda-create-static-group', data)
}

// 创建动态群组
export function createDynamicGroup(data: DynamicGroupCreateRequest) {
  return httpRequest.post('/api/lab/v1/experiment/group/bda-create-dynamic-group', data)
}

// 创建RFM群组
export function createRFMGroup(data: RFMGroupCreateRequest) {
  return httpRequest.post('/api/lab/v1/experiment/group/bda-create-frm-group', data)
}

// 更新RFM群组
export function updateRFMGroup(data: RFMGroupUpdateRequest) {
  return httpRequest.post('/api/lab/v1/experiment/group/bda-update-frm-group', data)
}

// 更新静态群组
export function updateStaticGroup(data: StaticGroupUpdateRequest) {
  return httpRequest.post('/api/lab/v1/experiment/group/bda-update-static-group', data)
}

// 更新动态群组
export function updateDynamicGroup(data: DynamicGroupUpdateRequest) {
  return httpRequest.post('/api/lab/v1/experiment/group/bda-update-dynamic-group', data)
}

// 删除群组
export function deleteGroup(data: { ids: string[] }) {
  return httpRequest.post('/api/lab/v1/experiment/group/bda-delete', data)
}

// 获取群组数据信息
export function getGroupStatistics(params: { group_id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/group/bda-statistics-detail', { params })
}

// 更新群组数据信息
export function updateGroupStatistics(data: { id: string }) {
  return httpRequest.post('/api/lab/v1/experiment/group/bda-statistics-user-group', data)
}

// 获取群组成员
export function getGroupMembers(params: { group_id: string; name?: string; id?: string }) {
  return httpRequest.get('/api/lab/v1/experiment/group/bda-members', { params })
}

// 清空静态群组成员
export function clearGroupMembers(data: { group_id: string }) {
  return httpRequest.post('/api/lab/v1/experiment/group/bda-clear-members', data)
}

// 搜索群组成员
export function searchGroupMembers(params: { group_id: string; name?: string; id?: string }) {
  return httpRequest.get('/api/lab/v1/experiment/group/bda-search-members', { params })
}

// 手动添加静态群组
export function addGroupMembers(data: { group_id: string; user_ids: string[] }) {
  return httpRequest.post('/api/lab/v1/experiment/group/bda-add-members', data)
}
