import httpRequest from '@/utils/axios'

// 获取实验直播商品品类的树形列表
export function getCategoryList(params?: { name?: string }) {
  return httpRequest.get('/api/lab/v1/experiment/live-commodity-type/trees', { params })
}

// 获取实验直播商品品类详情
export function getCategory(params: { id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/live-commodity-type/detail', { params })
}

// 创建实验直播商品品类
export function createCategory(data: { pid: string; name: string; status: string }) {
  return httpRequest.post('/api/lab/v1/experiment/live-commodity-type/create', data)
}

// 更新实验直播商品品类详情
export function updateCategory(data: { id: string; name: string; status: string }) {
  return httpRequest.post('/api/lab/v1/experiment/live-commodity-type/update', data)
}

// 删除实验直播商品品类
export function deleteCategory(data: { id: string }) {
  return httpRequest.post('/api/lab/v1/experiment/live-commodity-type/delete', data)
}
