import type { LabelType } from '../types'
import { getLabelTypeList } from '../api'

const labelCount = ref(0)
const typeList = ref<LabelType[]>([])
export function useLabelType() {
  function fetchTypeList() {
    getLabelTypeList().then(res => {
      labelCount.value = res.data.tag_count
      let defaultItems = res.data.default_items || []
      defaultItems = defaultItems.map((item: LabelType) => {
        return { ...item, is_default: true }
      })
      typeList.value = [...defaultItems, ...res.data.items]
    })
  }
  onMounted(() => {
    if (!typeList.value?.length) fetchTypeList()
  })
  return { fetchTypeList, typeList, labelCount }
}
