import httpRequest from '@/utils/axios'

// 获取实验直播商品的列表
export function getProductList(params?: {
  title?: string
  live_commodity_type_id?: string
  page: number
  'per-page': number
}) {
  return httpRequest.get('/api/lab/v1/experiment/live-commodity/list', { params })
}

// 获取实验直播商品详情
export function getProduct(params: { id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/live-commodity/detail', { params })
}

// 创建实验直播商品
export function createProduct(data: { pid: string; name: string; status: string }) {
  return httpRequest.post('/api/lab/v1/experiment/live-commodity/create', data)
}

// 更新实验直播商品详情
export function updateProduct(data: { id: string; name: string; status: string }) {
  return httpRequest.post('/api/lab/v1/experiment/live-commodity/update', data)
}

// 删除实验直播商品
export function deleteProduct(data: { id: string }) {
  return httpRequest.post('/api/lab/v1/experiment/live-commodity/delete', data)
}

// 获取实验直播商品品类的树形列表
export function getCategoryList(params?: { name?: string }) {
  return httpRequest.get('/api/lab/v1/experiment/live-commodity-type/trees', { params })
}

// 获取最近添加的直播商品品类
export function getCategoryTopicList() {
  return httpRequest.get('/api/lab/v1/experiment/live-commodity/recent-create-live-commodity-types')
}

// 搜索直播商品品类
export function searchCategory(params: { name: string }) {
  return httpRequest.get('/api/lab/v1/experiment/live-commodity-type/search', { params })
}

// 获取直播商品品类下的所有属性
export function getAttrList(params: { live_commodity_type_id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/live-commodity-attr/search', { params })
}

// 创客贴-查询我的设计(排序+筛选)
export function getChuanKitDesignList(data: {
  user_flag: string
  page_no: number
  page_size: number
  time_order: number
}) {
  return httpRequest.post('/api/lab/v1/experiment/marketing-ai/chuangkit-designs', data)
}
