import httpRequest from '@/utils/axios'
import type { StrategyListRequest, StrategyCreateRequest, StrategyUpdateRequest } from './types'

// 获取策略列表
export function getStrategyList(params?: StrategyListRequest) {
  return httpRequest.get('/api/lab/v1/experiment/operational-strategies/list', { params })
}

// 创建策略
export function createStrategy(data: StrategyCreateRequest) {
  return httpRequest.post('/api/lab/v1/experiment/operational-strategies/create', data)
}

// 更新策略
export function updateStrategy(data: StrategyUpdateRequest) {
  return httpRequest.post('/api/lab/v1/experiment/operational-strategies/update', data)
}

// 删除策略
export function deleteStrategy(data: { id: string }) {
  return httpRequest.post('/api/lab/v1/experiment/operational-strategies/delete', data)
}

// 获取策略详情
export function getStrategyInfo(params: { id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/operational-strategies/view', { params })
}
