import httpRequest from '@/utils/axios'

// 左侧实验数据
export function getExperimentData() {
  return httpRequest.get('/api/lab/v1/experiment/index/index')
}

// 用户
export function getMembersList() {
  return httpRequest.get('/api/lab/v1/experiment/index/members')
}

// 事件
export function getEventList(params: { member_id: string; page?: number; 'per-page'?: number }) {
  return httpRequest.get('/api/lab/v1/experiment/index/events', { params })
}

// 获取用户来源
export function getMemberConnections(params: { sso_id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/analyse/connections', { params })
}

// 获取热门标签
export function getHotTags(params: { sso_id: string; number?: number }) {
  return httpRequest.get('/api/lab/v1/experiment/analyse/hot-tags', { params })
}