import { defineStore } from 'pinia'
import { nanoid } from 'nanoid'

export interface State {
  member: MemberState
}

export interface MemberState {
  sex: string
  sex_file: string
  source: string
  source_file: string
  attrs: MemberAttr[]
}

export interface MemberAttr {
  id: string
  attr_id: string
  attr_content: string
  attr_file: string
}

export const useMemberStore = defineStore('member', {
  state: (): State => {
    return {
      member: {
        sex: '',
        sex_file: '',
        source: '',
        source_file: '',
        attrs: []
      }
    }
  },

  actions: {
    setData(data?: MemberState) {
      if (!data) return
      this.setMember(data)
    },
    setMember(data: MemberState) {
      this.member = Object.assign(this.member, data)
    },
    addAttr(data: Omit<MemberAttr, 'id'>) {
      this.member.attrs.push({ id: nanoid(4), ...data })
    },
    removeAttr(id: string) {
      this.member.attrs = this.member.attrs.filter(item => item.id !== id)
    }
  }
})
