import httpRequest from '@/utils/axios'

// 获取实验用户成员属性
export function getMemberAttrList(params: { type: number }) {
  return httpRequest.get('/api/lab/v1/experiment/tag/bda-member-attrs', { params })
}

// 获取实验事件和事件属性列表
export function getEventAttrList(params: { type: number }) {
  return httpRequest.get('/api/lab/v1/experiment/tag/bda-event-attrs', { params })
}

// 获取最大最小值
export function getMemberAttrRange(params: { member_meta_id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/tag/bda-num-member-attr-range', { params })
}

// 获取RFM标签的结果集
export function getRfmRes() {
  return httpRequest.get('/api/lab/v1/experiment/group/bda-rfm-res')
}

// 获取最近一次Rfm标签的统计结果
export function getRfmStatistics(params: { tag_id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/tag/bda-rfm-statistics-result', { params })
}
