import { getMemberMetaAttrs } from '../api'

// 所有成员
export interface UserType {
  id: string
  name: string
  english_name: string
  type: string
  format: string
}
const metaAttrList = ref<UserType[]>([])
export function useMetaAttr() {
  const metaAttrValue = ref('')
  async function fetchMetaAttrList() {
    const res = await getMemberMetaAttrs()
    metaAttrList.value = res.data.items
  }
  onMounted(() => {
    if (!metaAttrList.value?.length) fetchMetaAttrList()
  })
  return { fetchMetaAttrList, metaAttrList, metaAttrValue }
}
