import httpRequest from '@/utils/axios'

// 获取实验信息
export function getExperiment() {
  return httpRequest.get('/api/lab/v1/experiment')
}

// 获取列表搜索条件
export function getSearchCriteria() {
  return httpRequest.get('/api/lab/v1/experiment/marketing-planning/record-condition')
}

// 获取列表
export function getRecordList(params?: { name?: string, sno_number?: any }) {
  return httpRequest.get('/api/lab/v1/experiment/marketing-planning/record-list', { params })
}

// 获取平分
export function getScore(params?: { record_id: any }) {
  return httpRequest.get('/api/lab/v1/experiment/marketing-planning/score', { params })
}

// 更新评分
export function updateScore(data: { experiment_id: any; record_id: any,score: string }) {
  return httpRequest.post(`/api/lab/v1/experiment/marketing-planning/score?experiment_id=${data.experiment_id}&record_id=${data.record_id}`, data)
}
