import { getConnectionList } from '../api'

export interface ConnectionType {
  id: string
  type: string
  type_name: string
}
const connectionList = ref<ConnectionType[]>([])
export function useConnection() {
  async function fetchConnectionList() {
    const res = await getConnectionList()
    connectionList.value = res.data.items
  }
  onMounted(() => {
    if (!connectionList.value?.length) fetchConnectionList()
  })
  return { fetchConnectionList, connectionList }
}
