import httpRequest from '@/utils/axios'

// 获取实验详情
export function getExperiment() {
  return httpRequest.get('/api/lab/v1/experiment/once/experiment')
}

// 获取实验下的所有事件
export function getEventList() {
  return httpRequest.get('/api/lab/v1/experiment/analyse/events')
}

// 事件行为分布
export function getEventAction(params: { start_date: string; end_date: string; sso_id: string; event_id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/analyse/event-marketing-statistics', { params })
}

// 实验营销事件漏斗分析
export function getEventMarketing(params: { start_date: string; end_date: string; sso_id: string; event_id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/analyse/event-funnel-statistics', { params })
}

// 获取实验营销事件漏斗配置
export function getEventFunnel() {
  return httpRequest.get('/api/lab/v1/experiment/analyse/event-funnels')
}

// 保存实验营销事件漏斗配置
export function saveEventFunnel(data: { rules: Array<{ id: string; event_id: string; sort: number; name: string }> }) {
  return httpRequest.post('/api/lab/v1/experiment/analyse/save-event-funnels', data)
}

// 事件行为分布
export function getMemberList(params: { start_date: string; end_date: string; sso_id: string; event_id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/analyse/member-retention-statistics', { params })
}
