import httpRequest from '@/utils/axios'

// 获取直播练习报告
export function getReport(params?: { id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/live-practice-report/detail', { params })
}

// 获取直播练习报告列表
export function getReportList(params?: { live_commodity_type_id?: string; live_commodity_title?: string }) {
  return httpRequest.get('/api/lab/v1/experiment/live-practice-report/list', { params })
}

// 创建直播练习报告
export function createReport(data: { live_practice_id: string; report_name: string; report_url: string }) {
  return httpRequest.post('/api/lab/v1/experiment/live-practice-report/create', data)
}

// 删除直播练习报告
export function deleteReport(data: { id: string }) {
  return httpRequest.post('/api/lab/v1/experiment/live-practice-report/delete', data)
}

// 获取实验直播的列表
export function getTestList(params?: {
  live_commodity_id?: string
  live_commodity_type_id?: string
  live_commodity_title?: string
}) {
  return httpRequest.get('/api/lab/v1/experiment/live-practice/list', { params })
}
