import { defineStore } from 'pinia'
import { useObjectiveStore } from './objective'
import { useConnectionStore } from './connection'
import { useMemberStore } from './member'
import { useLabelStore } from './label'
import { useGroupStore } from './group'
import { useTripStore } from './trip'
import { useMaterialStore } from './material'

export const useMarketStore = defineStore('market', () => {
  const objectiveStore = useObjectiveStore()
  const connectionStore = useConnectionStore()
  const memberStore = useMemberStore()
  const labelStore = useLabelStore()
  const groupStore = useGroupStore()
  const tripStore = useTripStore()
  const materialStore = useMaterialStore()

  function setData(detail: any) {
    objectiveStore.setData(detail.step1)
    connectionStore.setData(detail.step2)
    memberStore.setData(detail.step3)
    labelStore.setData(detail.step4)
    groupStore.setData(detail.step5)
    tripStore.setData(detail.step6)
    materialStore.setData(detail.step7)
  }

  return {
    setData,
    objectiveStore,
    connectionStore,
    memberStore,
    labelStore,
    groupStore,
    tripStore,
    materialStore
  }
})
