export const generateCommodityTypePrompt = (data: any) => {
  return `请根据选手提交的商品品类信息进行评分（满分3分）：
选手提交内容：
${JSON.stringify(data.commodity_types)}

评分规则

一级品类创建（2分）

判定标准：
1.必须创建三个一级品类：速食面品类、鲜切面品类、调料配菜品类
2.状态必须为"有效"

计分规则：
●全部满足：2分
●缺少1个一级品类：扣1分
●状态非"有效"：扣0.5分
●扣分可累计，最低0分

二级品类创建（1分）

判定标准：

速食面品类下：
●至少2个二级品类
●必须包含：“复合式冲泡面”、“高端速食拌面/干面”
●状态为"有效"

鲜切面品类下：
●至少2个二级品类
●必须包含：“生鲜手擀/拉面”、“地方特色鲜面”
●状态为"有效"

调料配菜品类下：
●至少2个二级品类
●必须包含：“复合调味料包”、“即食真材配菜”
●状态为"有效"

计分规则：

●每个一级品类下必选项齐全且状态正确：+0.33分（共1分）
●必选项缺失：每项-0.1分
●状态非"有效"：每处-0.05分
●明显不合理命名：每处-0.05分
●扣分可累计，最低0分

【整体评价】
（请对选手整体表现进行1-2句总结性评价）`
}

export const generateCommodityAttrsPrompt = (data: any) => {
  return `
请根据选手提交的商品属性配置进行评分（满分2分）：

选手提交内容：
${JSON.stringify(data.commodity_attrs)}

评分规则

速食面品类属性（1分）
必须包含且名称合理的5项属性：
1.产品规格
2.口味类型
3.辣度等级
4.保质期
5.烹饪时长

计分规则：
●每项0.2分
●存在且名称合理即得分，不存在或名称不合理即0分
●不设部分分
●同义词、近似表达不计分（如"容量"不等于"产品规格"）

鲜切面品类属性（0.5分）
必须包含且名称合理的5项属性：
1.产品规格
2.面条类型
3.保存方式
4.保质期
5.适合人数

计分规则：
●每项0.1分
●存在且名称合理即得分，不存在或名称不合理即0分
●不设部分分
●同义词、近似表达不计分

调料配菜品类属性（0.5分）
必须包含且名称合理的5项属性：
1.产品规格
2.配料成分
3.辣度等级
4.保质期
5.适用场景

计分规则：

●每项0.1分
●存在且名称合理即得分，不存在或名称不合理即0分
●不设部分分
●同义词、近似表达不计分

判定说明
1.精确匹配原则：本模块计分以"属性名是否存在且名称合理"作为依据
2.同义词处理：同义词、近似表达不计分（如"容量"不等于"产品规格"）
3.其他字段：重要性、必要性、状态设置是否合理不影响本模块计分，但可在评价中提及`
}

export const generateCommoditiesPrompt = (data: any) => {
  return `
一、角色定位（Role）
你是一位专业的电商运营评分专家，负责对选手的商品信息维护操作进行客观、准确的评分（满分10分）。

核心原则：

严格证据链原则：所有评分必须基于输入信息中的实际内容，不得推测、臆断或补充

有据可查原则：每一项得分或扣分都必须明确指出依据来源

客观公正原则：仅评价可见的、已配置的内容，未配置的不扣分、不臆测

二、任务说明（Task）
根据选手实际的答题结果（商品详情配置页导出或截图、媒体素材清单），结合试题要求，对商品信息维护的完成情况进行评分。

输入信息
${JSON.stringify(data.commodities)}

试题要求：主推商品为"襄阳牛肉面2桶装（有牛肉）"，完成5个板块的全面维护

三、评分目标（Goal）
准确、公正地评价选手在以下5个板块的操作完成情况，总分10分：

商品类目关联（1分）

商品主图配置（2分）

3:4比例主图配置（1分）

价格库存配置（4分）

服务履约配置（2分）

四、详细评分规则（Objective）
4.1 商品类目关联（1分）
判定标准
必须检查项：

一级品类："襄阳牛肉面2桶装（有牛肉）"应关联到"速食面品类"

二级品类：应关联到"速食面品类"下的"复合式冲泡面"

计分规则
| 情况 | 得分 | 判定依据 |

| ------------------------------ | ----- | ----------------------------------------------------- |

| 一级品类 ✅ 且 二级品类 ✅ | 1分 | 在商品详情配置页中明确显示"速食面品类 > 复合式冲泡面" |

| 仅一级品类 ✅ 或 仅二级品类 ✅ | 0.5分 | 仅显示其中一项正确 |

| 两者都错误或缺失 | 0分 | 未找到类目信息，或类目错误 |

评分示例
✅ 得1分：配置页显示"类目：速食面品类 > 复合式冲泡面"

⚠️ 得0.5分：配置页显示"类目：速食面品类"（缺少二级分类）

❌ 得0分：配置页显示"类目：方便食品"（一级分类错误）

4.2 商品主图配置（2分）
判定标准
必须检查项：

图片数量：至少2张

图片比例：必须为1:1比例

图片来源：从"媒体素材清单"或"商品详情配置页"中统计

计分规则
| 图片数量 | 得分 | 判定依据 |

| ------------- | ----------- | ---------------------------------------------------------- |

| ≥2张 1:1主图 | 2分 | 媒体素材清单或配置页中显示≥2张标注为"1:1"或"正方形"的图片 |

| 仅1张 1:1主图 | 1分（-1分） | 仅找到1张1:1图片 |

| 0张 1:1主图 | 0分（-2分） | 未找到任何1:1图片 |

评分示例
✅ 得2分：媒体素材清单显示"主图1.jpg (1:1)"、"主图2.jpg (1:1)"

⚠️ 得1分：媒体素材清单仅显示"主图1.jpg (1:1)"

❌ 得0分：媒体素材清单中所有图片均为"3:4"或未标注比例

特别说明
图片比例判定：仅根据素材清单中的标注或图片尺寸信息判断（如800x800、1080x1080为1:1）

不判定质量：仅统计数量和比例，不评价图片内容质量

4.3 3:4比例主图配置（1分）
判定标准
必须检查项：

图片数量：至少1张

图片比例：必须为3:4比例

图片来源：从"媒体素材清单"或"商品详情配置页"中统计

计分规则
| 图片数量 | 得分 | 判定依据 |

| ------------- | ---- | -------------------------------------------------------------------------------- |

| ≥1张 3:4主图 | 1分 | 媒体素材清单或配置页中显示≥1张标注为"3:4"或"竖版"的图片（如750x1000、900x1200） |

| 0张 3:4主图 | 0分 | 未找到任何3:4图片 |

评分示例
✅ 得1分：媒体素材清单显示"主图3.jpg (3:4)"或"750x1000"

❌ 得0分：所有图片均为其他比例

4.4 价格库存配置（4分）
判定标准
必须检查项（共4项，每项1分）：

| 检查项 | 判定依据 | 扣分规则 |

| ------------------- | --------------------------------------------------------------------------------------------------------------------- | ------------------------------- |

| ① 商品规格 | 商品详情配置页中明确显示规格列表（如"口味：原味/辣味"、"颜色：红/蓝"等），或显示"SKU列表"、"规格管理"等模块 | 未配置规格或规格信息缺失，扣1分 |

| ② 价格 | 每个规格都配置了"销售价格"或"价格"字段，且数值>0 | 任一规格缺失价格或=0，扣1分 |

| ③ 参考价（划线价） | 每个规格都配置了"原价"或"市场价"或"参考价"字段，且数值>0 | 任一规格缺失参考价或=0，扣1分 |

| ④ 库存数量 | 每个规格都配置了"库存"或"可售数量"字段，且数值>0 | 任一规格缺失库存或=0，扣1分 |

⚠️ 特别说明：

发货模式已从本项移除，归入"服务履约配置"板块统一管理

规格是必检项：不同规格对应不同的价格、参考价、库存，必须检查规格配置情况

计分规则
起评分：4分

累计扣分：每缺少一项扣1分

最低得分：0分（扣完为止）

规格判定标准详解（防止臆测）
✅ 判定为"已配置规格"的证据（必须满足以下任一条件）：

明确的规格列表：配置页中显示规格名称和选项

示例：规格：口味（原味、辣味）

示例：SKU规格：颜色（红、蓝、黑）/ 尺码（S、M、L）

SKU管理表格：配置页中有SKU列表，每行代表一个规格组合


SKU列表：

- 原味/2桶装：价格29.9元，库存500件

- 辣味/2桶装：价格32.9元，库存300件

规格管理模块：配置页中有"规格管理"、"SKU管理"、"多规格设置"等明确标识

❌ 不能判定为"已配置规格"的情况（严禁臆测）：

❌ 仅看到商品名称包含"2桶装"，但配置页中无规格模块 → 未配置规格

❌ 仅看到一个价格，未显示规格列表 → 未配置规格

❌ 配置页中无"规格"相关字段或模块 → 未配置规格

❌ 主观推测"商品应该有规格" → 严禁臆测，必须以实际显示为准

评分示例
情况A：单规格商品（已配置规格）

✅ 得4分（满分）：


商品配置页显示：

━━━━━━━━━━━━━━━

【规格管理】

规格：口味

选项：原味

 

【SKU列表】

- 原味：

  · 销售价格：29.9元 ✓

  · 参考价：49.9元 ✓

  · 库存：500件 ✓

━━━━━━━━━━━━━━━

 

评分：

① 规格：已配置（1个规格"原味"）✓

② 价格：已配置（29.9元）✓

③ 参考价：已配置（49.9元）✓

④ 库存：已配置（500件）✓

 

得分：4/4分

情况B：多规格商品（已配置规格）

✅ 得4分（满分）：


商品配置页显示：

━━━━━━━━━━━━━━━

【规格管理】

规格：口味

选项：原味、辣味

 

【SKU列表】

- 原味：价格29.9元，参考价49.9元，库存500件 ✓

- 辣味：价格32.9元，参考价52.9元，库存300件 ✓

━━━━━━━━━━━━━━━

 

评分：

① 规格：已配置（2个规格"原味、辣味"）✓

② 价格：已配置（所有规格都有价格）✓

③ 参考价：已配置（所有规格都有参考价）✓

④ 库存：已配置（所有规格都有库存）✓

 

得分：4/4分

情况C：未配置规格（错误案例）

❌ 得0分（-4分）：


商品配置页显示：

━━━━━━━━━━━━━━━

【商品信息】

商品名称：襄阳牛肉面2桶装（有牛肉）

商品图片：已上传

 

⚠️ 未找到"规格管理"、"SKU列表"等模块

⚠️ 未显示任何规格信息

━━━━━━━━━━━━━━━

 

评分：

① 规格：未配置 ✗（扣1分）

② 价格：因未配置规格，无法填写价格 ✗（扣1分）

③ 参考价：因未配置规格，无法填写参考价 ✗（扣1分）

④ 库存：因未配置规格，无法填写库存 ✗（扣1分）

 

得分：0/4分

扣分原因：商品配置页中未找到规格管理模块，未配置任何规格信息，导致价格、参考价、库存无法配置。

情况D：配置了规格，但部分规格缺失价格

⚠️ 得3分（-1分）：


商品配置页显示：

━━━━━━━━━━━━━━━

【规格管理】

规格：口味

选项：原味、辣味

 

【SKU列表】

- 原味：价格29.9元，参考价49.9元，库存500件 ✓

- 辣味：价格未填写，参考价52.9元，库存300件 ✗

━━━━━━━━━━━━━━━

 

评分：

① 规格：已配置 ✓

② 价格：部分缺失（"辣味"规格未填写价格）✗（扣1分）

③ 参考价：已配置 ✓

④ 库存：已配置 ✓

 

得分：3/4分

扣分原因："辣味"规格未配置销售价格。

严格评分要求（防止AI臆测）
评分时必须回答以下问题（证据链检查）：

规格证据问题：

❓ 在配置页的哪个位置看到了规格信息？

❓ 规格名称是什么？（如"口味"、"颜色"、"尺码"等）

❓ 有几个规格选项？分别是什么？

价格证据问题：

❓ 每个规格的价格分别是多少？

❓ 是否所有规格都配置了价格？

参考价证据问题：

❓ 每个规格的参考价分别是多少？

❓ 是否所有规格都配置了参考价？

库存证据问题：

❓ 每个规格的库存分别是多少？

❓ 是否所有规格都配置了库存？

⚠️ 如果以上任何一个问题无法从配置页中找到明确答案，则该项判定为"未配置"，不得臆测！

4.5 服务履约配置（2分）
判定标准
必须检查项（3项）：

| 检查项 | 判定依据 | 分值 |

| ----------- | ------------------------------------------------ | ----- |

| ① 发货模式 | 商品详情配置页中明确显示"现货发货"或"48小时发货" | 0.5分 |

| ② 运费模板 | 从指定选项中至少配置1项 | 1分 |

| ③ 售后政策 | 从指定选项中至少配置1项 | 0.5分 |

② 运费模板选项（至少配置1项）：

阶梯计价运费

固定运费

卖家包邮

指定条件包邮

限制买家下单区域

按件数计价

按重量计价

指定地区运费

③ 售后政策选项（至少配置1项）：

7天无理由退换货

全额退款

仅退款政策

预付邮费标签

全球购物保障计划

无忧退换货

闪电退货

售后补寄

计分规则
起评分：2分

累计扣分：每缺少一项按对应分值扣分

最低得分：0分（扣完为止）

评分示例
✅ 得2分（满分）：


商品配置页显示：

- 发货模式：现货发货 ✓（0.5分）

- 运费模板：卖家包邮 ✓（1分）

- 售后政策：7天无理由退换货 ✓（0.5分）

 

得分：2/2分

⚠️ 得1.5分（-0.5分）：


商品配置页显示：

- 发货模式：现货发货 ✓（0.5分）

- 运费模板：固定运费 ✓（1分）

- 售后政策：未设置 ✗（扣0.5分）

 

得分：1.5/2分

扣分原因：未配置售后政策。

⚠️ 得0.5分（-1.5分）：


商品配置页显示：

- 发货模式：预售发货 ✗（扣0.5分，应为"现货发货"）

- 运费模板：未设置 ✗（扣1分）

- 售后政策：7天无理由退换货 ✓（0.5分）

 

得分：0.5/2分

扣分原因：发货模式错误，应设置为"现货发货"；未配置运费模板。

❌ 得0分（-2分）：


商品配置页显示：

- 发货模式：未设置 ✗（扣0.5分）

- 运费模板：未设置 ✗（扣1分）

- 售后政策：未设置 ✗（扣0.5分）

 

得分：0/2分

扣分原因：发货模式、运费模板、售后政策均未配置。

五、评分输出模板
5.1 评分记录（结构化格式）

【商品信息维护评分报告】

 

━━━━━━━━━━━━━━━━━━━━━━━━

【1. 商品类目关联】

━━━━━━━━━━━━━━━━━━━━━━━━

 

得分：___/1分

 

判定依据：

- 一级品类：【已配置/未配置/配置错误】：__________

- 二级品类：【已配置/未配置/配置错误】：__________

 

扣分原因：__________（如无扣分，填"无"）

 

━━━━━━━━━━━━━━━━━━━━━━━━

【2. 商品主图配置】

━━━━━━━━━━━━━━━━━━━━━━━━

 

得分：___/2分

 

判定依据：

- 1:1主图数量：____张

- 图片来源：【媒体素材清单/商品配置页】

- 图片信息：__________

 

扣分原因：__________（如无扣分，填"无"）

 

━━━━━━━━━━━━━━━━━━━━━━━━

【3. 3:4比例主图】

━━━━━━━━━━━━━━━━━━━━━━━━

 

得分：___/1分

 

判定依据：

- 3:4主图数量：____张

- 图片来源：【媒体素材清单/商品配置页】

- 图片信息：__________

 

扣分原因：__________（如无扣分，填"无"）

 

━━━━━━━━━━━━━━━━━━━━━━━━

【4. 价格库存配置】

━━━━━━━━━━━━━━━━━━━━━━━━

 

得分：___/4分

 

判定依据（必须回答证据链问题）：

 

**① 商品规格（1分）**

- 是否配置规格：【已配置/未配置】

- 规格信息位置：在配置页的________位置找到

- 规格名称：________（如"口味"、"颜色"等）

- 规格选项：________（如"原味、辣味"）

- 规格数量：共____个规格

 

**② 价格配置（1分）**

- 是否配置价格：【已配置/部分配置/未配置】

- 价格信息：

  * 规格1（______）：价格______元

  * 规格2（______）：价格______元

  * （如有更多规格，请列出）

 

**③ 参考价配置（1分）**

- 是否配置参考价：【已配置/部分配置/未配置】

- 参考价信息：

  * 规格1（______）：参考价______元

  * 规格2（______）：参考价______元

  * （如有更多规格，请列出）

 

**④ 库存配置（1分）**

- 是否配置库存：【已配置/部分配置/未配置】

- 库存信息：

  * 规格1（______）：库存______件

  * 规格2（______）：库存______件

  * （如有更多规格，请列出）

 

扣分原因：__________（如无扣分，填"无"）

 

⚠️ 评分检查：如果无法从配置页中明确回答上述问题，则该项判定为"未配置"，不得臆测！

 

━━━━━━━━━━━━━━━━━━━━━━━━

【5. 服务履约配置】

━━━━━━━━━━━━━━━━━━━━━━━━

 

得分：___/2分

 

判定依据：

- ① 发货模式（0.5分）：【现货发货/其他/未配置】：__________

- ② 运费模板（1分）：【已配置/未配置】：__________

- ③ 售后政策（0.5分）：【已配置/未配置】：__________

 

扣分原因：__________（如无扣分，填"无"）

 

━━━━━━━━━━━━━━━━━━━━━━━━

【总分统计】

━━━━━━━━━━━━━━━━━━━━━━━━

 

本模块总分：___/10分

 

各板块得分明细：

- 商品类目关联：___/1分

- 商品主图配置：___/2分

- 3:4比例主图：___/1分

- 价格库存配置：___/4分

- 服务履约配置：___/2分

5.2 综合评价（质性分析）

━━━━━━━━━━━━━━━━━━━━━━━━

【整体评价】

━━━━━━━━━━━━━━━━━━━━━━━━

 

________________________________________

（100-150字，客观描述选手的整体表现）

 

━━━━━━━━━━━━━━━━━━━━━━━━

【亮点】

━━━━━━━━━━━━━━━━━━━━━━━━

 

1. __________________

2. __________________

 

━━━━━━━━━━━━━━━━━━━━━━━━

【不足】

━━━━━━━━━━━━━━━━━━━━━━━━

 

1. __________________

2. __________________

 

━━━━━━━━━━━━━━━━━━━━━━━━

【改进建议】

━━━━━━━━━━━━━━━━━━━━━━━━

 

1. __________________

2. __________________

六、评分核心要求（Critical Rules）
⚠️ 严格遵守以下规则
规则1：证据链原则
✅ 正确做法：


判定依据：配置页中明确显示"销售价格：29.9元"

得分：1分（价格已配置）

❌ 错误做法：


判定依据：商品应该配置了价格

得分：1分（臆测）

规则2：有据可查原则
✅ 正确做法：


扣分原因：配置页中未找到"参考价"字段，扣1分

❌ 错误做法：


扣分原因：参考价可能没配置，扣1分

规则3：不臆测原则
✅ 正确做法：


判定依据：配置页中未显示规格信息

⚠️ 本项不检查规格，不影响得分

❌ 错误做法：


判定依据：商品应该有规格但未看到，扣分

（严禁！规格不在评分范围内）

规则4：信息缺失处理原则
当输入信息不完整时：

| 情况 | 处理方式 |

| ------------------------------------ | ---------------------------------- |

| 配置页截图模糊，无法判断某项是否配置 | 标注"因截图模糊无法判断，暂不扣分" |

| 素材清单缺失，无法统计图片数量 | 标注"因素材清单缺失，无法评分" |

| 配置页中明确显示"未配置"或字段为空 | 按规则扣分 |

七、评分流程（Workflow）
步骤1：信息审查
检查输入信息是否完整（商品配置页 + 媒体素材清单）

确认商品名称是否为"襄阳牛肉面2桶装（有牛肉）"

如有缺失，在评分报告中标注

步骤2：逐项评分
按照5个板块的顺序，逐项检查并记录：

在输入信息中寻找对应的证据

记录判定依据（具体字段名称和值）

根据计分规则给出得分

如有扣分，明确写出扣分原因

步骤3：交叉验证
检查各板块得分相加是否等于总分

确认所有"判定依据"都有具体来源

确认未出现臆测或推断性表述

步骤4：输出报告
按照"5.1 评分记录"模板填写结构化数据

按照"5.2 综合评价"模板填写质性分析

最终输出完整的评分报告

八、常见错误示例与纠正
错误示例1：臆测规格存在（最常见错误）
❌ 错误评分：


【4. 价格库存配置】得分：4/4分

 

判定依据：

- ① 规格：已配置（应该有规格）✓

- ② 价格：已配置 ✓

- ③ 参考价：已配置 ✓

- ④ 库存：已配置 ✓

 

扣分原因：无

错误原因：未在配置页中找到明确的规格信息，主观臆测"应该有规格"

✅ 正确评分：


【4. 价格库存配置】得分：0/4分

 

判定依据（证据链检查）：

 

① 商品规格（1分）

- 是否配置规格：未配置 ✗

- 规格信息位置：配置页中未找到"规格管理"、"SKU列表"等模块

- 规格名称：无

- 规格选项：无

- 规格数量：0个

 

② 价格配置（1分）

- 是否配置价格：未配置 ✗

- 原因：因未配置规格，无法填写价格

 

③ 参考价配置（1分）

- 是否配置参考价：未配置 ✗

- 原因：因未配置规格，无法填写参考价

 

④ 库存配置（1分）

- 是否配置库存：未配置 ✗

- 原因：因未配置规格，无法填写库存

 

扣分原因：商品配置页中未找到规格管理模块，未配置任何规格信息，导致价格、参考价、库存无法配置。

纠正说明：必须在配置页中看到明确的规格列表或SKU管理模块，才能判定为"已配置规格"

错误示例2：将商品名称中的描述当作规格
❌ 错误评分：


【4. 价格库存配置】得分：4/4分

 

判定依据：

- ① 规格：已配置（商品名称中有"2桶装"）✓

错误原因：将商品名称"襄阳牛肉面2桶装（有牛肉）"中的"2桶装"误认为是规格

✅ 正确评分：


【4. 价格库存配置】得分：0/4分

 

判定依据：

① 商品规格

- 是否配置规格：未配置 ✗

- ⚠️ 说明：商品名称中的"2桶装"是商品描述，不是配置的规格

- ⚠️ 判定标准：必须在配置页中看到"规格管理"模块或"SKU列表"

纠正说明：商品名称中的描述（如"2桶装"）不等于规格配置，必须在配置页中有明确的规格管理模块

错误示例3：缺乏判定依据
❌ 错误评分：


【1. 商品类目关联】得分：1/1分

判定依据：类目配置正确

错误原因：未说明在哪里看到类目信息，无法验证

✅ 正确评分：


【1. 商品类目关联】得分：1/1分

判定依据：

- 一级品类：已配置：配置页显示"速食面品类"

- 二级品类：已配置：配置页显示"复合式冲泡面"

 

扣分原因：无

错误示例4：未看到SKU列表却判定价格已配置
❌ 错误评分：


【4. 价格库存配置】得分：4/4分

 

判定依据：

- ② 价格：已配置 ✓（应该有价格）

错误原因：未说明价格的具体数值和来源，无法验证

✅ 正确评分方式A（已配置规格的情况）：


【4. 价格库存配置】得分：4/4分

 

判定依据：

② 价格配置

- 是否配置价格：已配置 ✓

- 价格信息：

  * 原味规格：价格29.9元（见配置页SKU列表第1行）

  * 辣味规格：价格32.9元（见配置页SKU列表第2行）

✅ 正确评分方式B（未配置规格的情况）：


【4. 价格库存配置】得分：0/4分

 

判定依据：

② 价格配置

- 是否配置价格：未配置 ✗

- 原因：配置页中未找到SKU列表或价格字段

错误示例5：信息缺失时的错误处理
❌ 错误评分：


【2. 商品主图配置】得分：0/2分

扣分原因：未提供素材清单，判断为未配置

错误原因：信息缺失不应扣分，应标注"无法评分"

✅ 正确评分：


【2. 商品主图配置】得分：无法评分

扣分原因：因未提供媒体素材清单，无法统计主图数量，建议补充素材信息后重新评分

九、质量检查清单
在提交评分报告前，请自检：

证据链检查
[ ] 每一项得分都有明确的"判定依据"，且能在输入信息中找到对应内容

[ ] "判定依据"中引用了具体的字段名称、位置和数值

[ ] 所有扣分原因都具体、明确，无"可能""应该""大概"等模糊表述

[ ] 未出现臆测、推断、补充信息的情况

规格判定检查（重点）
[ ] 必须回答：在配置页的哪个位置看到了规格信息？

[ ] 必须回答：规格名称是什么？有几个规格选项？

[ ] 必须回答：每个规格的价格、参考价、库存分别是多少？

[ ] 严禁臆测：如果配置页中未显示规格管理模块或SKU列表，则判定为"未配置规格"

[ ] 严禁臆测：不能根据商品名称（如"2桶装"）推测规格已配置

数据一致性检查
[ ] 各板块得分相加等于总分（商品类目1分+主图2分+3:4主图1分+价格库存4分+服务履约2分=10分）

[ ] 如果"规格"判定为"未配置"，则"价格、参考价、库存"也应判定为"未配置"

[ ] 如果"规格"判定为"已配置"，必须列出每个规格的详细信息

信息缺失处理检查
[ ] 如有信息缺失（如素材清单缺失），已明确标注"无法评分"而非扣分

[ ] 如有截图模糊无法判断，已标注"因截图模糊无法判断，暂不扣分"

反臆测检查（最重要）
以下情况严禁判定为"已配置"，请再次确认：

[ ] ❌ 仅看到商品名称包含"2桶装"，但配置页中无规格模块 → 未配置规格

[ ] ❌ 仅看到一个价格，未显示规格列表 → 未配置规格

[ ] ❌ 配置页中无"规格管理"、"SKU列表"、"SKU管理"等字段或模块 → 未配置规格

[ ] ❌ 主观推测"商品应该有规格" → 严禁臆测，必须以实际显示为准

十、规格判定快速诊断工具
使用方法：在评分"价格库存配置"板块前，先用此工具诊断规格配置情况

诊断流程图

开始评分"价格库存配置"

    ↓

【问题1】配置页中是否有"规格管理"、"SKU管理"、"规格设置"等模块？

    ├─ 是 → 继续【问题2】

    └─ 否 → ❌ 判定为"未配置规格"，得0分

  

【问题2】是否能明确看到规格名称（如"口味"、"颜色"、"尺码"）？

    ├─ 是 → 继续【问题3】

    └─ 否 → ❌ 判定为"未配置规格"，得0分

  

【问题3】是否能明确看到规格选项（如"原味、辣味"）？

    ├─ 是 → 继续【问题4】

    └─ 否 → ❌ 判定为"未配置规格"，得0分

  

【问题4】是否有SKU列表，且每个规格都有价格、参考价、库存？

    ├─ 全部有 → ✅ 判定为"已配置规格"，得4分

    ├─ 部分有 → ⚠️ 判定为"部分配置"，按缺失项扣分

    └─ 全部无 → ❌ 判定为"未配置规格"，得0分

快速判定表
| 配置页显示内容 | 判定结果 | 得分 |

| ----------------------------------------------- | ---------- | -------------- |

| ✅ 有"规格管理"模块 + 规格列表 + SKU价格/库存表 | 已配置规格 | 4分（满分） |

| ⚠️ 有"规格管理"模块，但部分规格缺失价格/库存 | 部分配置 | 按缺失项扣分 |

| ❌ 无"规格管理"模块，仅有商品名称 | 未配置规格 | 0分 |

| ❌ 仅看到一个价格，无规格列表 | 未配置规格 | 0分 |

| ❌ 商品名称包含"2桶装"，但无规格模块 | 未配置规格 | 0分 |

| ❓ 信息缺失，无法判断 | 无法评分 | 标注"无法评分" |

典型错误案例对照
| 错误判定 ✗ | 正确判定 ✓ | 原因 |

| -------------------------------- | -------------------------------- | ------------------------------ |

| "商品名称有'2桶装'，规格已配置" | "未配置规格"（商品名称不是规格） | 商品名称中的描述不等于规格配置 |

| "应该有规格，判定为已配置" | "未配置规格"（未看到规格模块） | 主观臆测，缺乏证据 |

| "看到一个价格29.9元，规格已配置" | "未配置规格"（未看到规格列表） | 单独的价格不代表配置了规格 |

| "商品肯定有颜色，规格已配置" | "未配置规格"（未看到规格列表） | 主观推测，缺乏证据 |

`
}

export const generateSpeechPrompt = (data: any) => {
  return `
请根据选手提交的直播话术进行评分（满分15分）

选手提交内容内容：
${JSON.stringify(data.speeches)}

评分规则
1. 直播话术名称（3分）
判定标准：
●5-20字
●主题明确，体现直播主题

计分规则：
●符合要求：3分
●不符合：-1.5分（得1.5分）

2. 直播主题卖点（3分）
判定标准：
●每个商品≥3个核心卖点
●具体有说服力
●针对目标用户痛点

计分规则：
●每缺1个卖点：-1分
●描述空泛：每处-0.5分（上限-1分）
●扣分累计，最低0分

3. 营销活动设计（3分）
判定标准：
●至少3个活动
●活动形式多样化
●优惠力度合理
●必须包含：限时秒杀活动、组合优惠活动、互动抽奖活动

计分规则：
●不足3个活动：-1分
●缺1类必选活动：-1分
●规则不清：-0.5分
●扣分累计，最低0分

4. 直播话术脚本撰写（4分）
必须包含以下环节，缺环节-0.5分/项：
1.开场白环节：热情问候、主题引入、福利预告、引导关注
2.品牌介绍环节：品牌故事、品牌实力、产品线介绍
3.主推产品讲解环节：产品展示、成分讲解、卖点阐述、使用场景、案例分享、价格优惠、促单话术
4.互动环节：回应评论、互动问答、抽奖活动
5.促销推动环节：强调组合优惠、满额包邮、催单话术
6.结束语环节：总结要点、感谢支持、预告下播、最后提醒

话术质量要求：
●语言自然流畅，口语化表达
●逻辑清晰，节奏合理
●卖点讲解充分，有说服力
●互动环节设计合理，能调动氛围
●促销话术到位，但不过度推销
●无违禁词

常见违禁词快速对照表
类别1：绝对化用语（共20个）
最、最佳、最好、最优、最大、最小、最新、最先进
第一、首个、首选、唯一、独一无二、前无古人
极致、完美、顶级、至尊、终极、巅峰

类别2：夸大宣传（共15个）
100%、百分百、保证、必然、绝对、肯定
立竿见影、立即见效、马上见效、即刻
永久、终身、永远、一劳永逸、彻底

类别3：医疗用语（共20个）
治疗、治愈、医治、疗效、药用、处方
抗炎、消炎、杀菌、灭菌、防癌、抗癌
降血压、降血糖、降血脂、治痤疮、祛痘、去斑
修复、再生（需谨慎使用）

类别4：虚假宣传（共10个）
国家级、世界级、全球级、宇宙级
最高级、最低价、史无前例、前所未有
销量第一、市场占有率第一

计分规则：
●缺环节：-0.5分/项
●明显质量问题：每处-0.5分
●扣分累计，最低0分

5. 时长设置（2分）
判定标准：
●设置为15分钟
●时间分配合理（重点突出、互动穿插）

计分规则：
●符合要求：2分
●未设置或明显不合理：0分

【整体评价】
（请对选手话术整体质量进行1-2句总结性评价）`
}

export const generatePracticeRecordPrompt = (data: any) => {
  const firstLivePractice = data.practices[0]
  const firstLivePracticeRecord = firstLivePractice?.records[0]
  return `请根据选手提交的内容进行评分（满分15分）
选手提交内容：
  ${JSON.stringify(firstLivePracticeRecord)}

评分规则
1. 开场与氛围营造（2分）
判定标准：
●开场白吸引人
●快速进入状态
●营造良好直播氛围

计分规则：
●符合要求：2分
●表现一般：-1分（得1分）
●表现不足：-2分（得0分）

2. 商品讲解能力（3分）
判定标准：
●商品介绍清晰准确
●重点突出
●讲解有说服力

计分规则：
●符合要求：3分
●表现一般：-1.5分（得1.5分）
●表现不足：-3分（得0分）

3. 互动回应能力（2分）
判定标准：
●及时回应观众评论和问题
●互动自然流畅

计分规则：
●符合要求：2分
●表现一般：-1分（得1分）
●表现不足：-2分（得0分）

4. 促销引导能力（2分）
判定标准：
●有效引导观众关注、点赞、下单
●转化技巧运用得当
计分规则：
●符合要求：2分
●表现一般：-1分（得1分）
●表现不足：-2分（得0分）

5. 语言表达与形象（4分）
判定标准：
●普通话标准
●语速适中（理想区间：180-220字/分钟）
●表情自然
●形象得体
计分规则：
●全部符合：4分
●语速偏离：-1分
●普通话不标准：-1分
●表情不自然：-1分
●形象不得体：-1分
●扣分累计，最低0分
语速标准参考
理想语速：180-220 字/分钟
- 观众能够轻松跟上
- 有足够时间理解信息
- 节奏舒适，不紧不慢
偏快语速：221-240 字/分钟
- 部分观众可能跟不上
- 影响信息吸收效果
- 建议适当放慢
过快语速：>240 字/分钟
- 大部分观众难以跟上
- 严重影响直播效果
- 必须改进
偏慢语速：150-179 字/分钟
- 节奏稍显拖沓
- 可能影响直播间活跃度
- 建议适当加快
过慢语速：<150 字/分钟
- 节奏过于拖沓
- 观众容易失去耐心
- 必须改进

6. 内容合规性（2分）
判定标准：
●严格遵守《网络主播行为规范》
●无违规内容
●无违禁词

计分规则：
●完全合规：2分
●有轻微违规：-1分（得1分）
●有明显违规：-2分（得0分）
《网络主播行为规范》31项禁止行为（重点摘要）：
（一）政治与意识形态类
1.恶搞、歪曲、丑化党和国家形象；
2.散布谣言、煽动颠覆国家政权、分裂国家领土；
3.宣传封建迷信、邪教、恐怖主义等内容。
（二）低俗庸俗类
1.展示淫秽、色情、暴力、血腥画面；
2.着装暴露、动作挑逗、打“擦边球”；
3.使用粗俗语言、侮辱性词汇、地域歧视等。
（三）虚假宣传与消费误导类
1.虚假宣传商品功效、产地、成分、质量；
2.使用“国家级”“最优惠”“第一品牌”等绝对化用语；
3.伪造销量、用户评价、直播间人气；
4.谎称“最后X件”“仅限今天”制造抢购氛围；
5.诱导未成年人非理性消费或打赏；
6.未标明广告属性，以“自用推荐”名义进行商业推广。
（四）知识产权与版权类
1.未经授权播放音乐、影视、游戏画面；
2.盗用他人直播内容、脚本、创意；
3.使用他人肖像、声音、商标未经许可。
（五）食品安全与健康风险类
1.无资质宣传医疗、药品、保健食品功效；
2.推荐“三无产品”、过期食品、违禁品；
3.试吃来源不明、无检验合格证明的食品；
4.宣称普通食品具有“治疗疾病”“增强免疫力”等医疗效果。
（六）其他违规行为
1.酒后直播、醉酒状态出镜；
2.直播赌博、诈骗、传销等活动；
3.泄露他人隐私、个人信息；
4.冒充专家、医生、律师等专业人士；
5.恶意炒作、拉踩同行、制造对立；
6.在公共场所直播影响公共秩序；
7.利用直播进行非法集资、金融诈骗；
8.传播伪科学、反智言论；
9.侵犯消费者合法权益（如不退不换、虚假售后）；
10.不配合平台或监管部门调查；
11.未取得相关资质从事特定领域直播（如医疗、教育、金融）；
12.其他违反法律法规及公序良俗的行为。
特别针对“电商/带货主播”的强化要求
1.商品审核义务
○主播应对所售商品基本信息（成分、产地、保质期、适用人群）进行核实；
○不得为“三无产品”、假冒伪劣、违禁品带货。
1.广告标识义务
○凡涉及商业推广的内容，应明确标注“广告”“推广”字样；
○不得以“自用推荐”“朋友家产品”等模糊方式规避广告责任。
1.售后与责任承担
○若主播以自身名义推荐商品（如“XX严选”“主播同款”），可能被认定为广告代言人，需对产品质量承担连带责任；
○应配合平台处理消费者投诉，不得推诿、搪塞。
1.数据真实性
○禁止刷单、刷评、虚构交易额、观看量；
○平台将对异常数据进行监测并处罚。`
}

export const generateImprovementPlanPrompt = (data: any) => {
  const firstLivePractice = data.practices[0]
  const firstLivePracticeRecord = firstLivePractice?.records[0]
  return `请根据选手提交的改进方案进行评分（满分10分）：
选手提交的改进方案：
  ${JSON.stringify(firstLivePracticeRecord?.improvement_plan)}
评分规则
1. 改进方案数量（10分）
判定标准：
1.数量要求：至少5条具体的改进措施
2.内容要求：每条改进措施必须包括：
○问题描述
○改进目标
○改进方法
1.维度要求：改进方案需涵盖语速、违禁词、卖点讲解、互动、促销等多个维度
计分规则：
●不足5条：每缺1条-2分
●每条改进措施缺少三要素之一：每处-0.5分
●未覆盖多维度：-1分
●扣分累计，但本项最低0分`
}

export const generatePracticeRecord2Prompt = (data: any) => {
  const secondLivePractice = data.practices[1]
  const secondLivePracticeRecord = secondLivePractice?.records[0]
  return `
请根据选手提交的二次直播演练内容进行评分（满分30分）
选手提交内容：
  ${JSON.stringify(secondLivePracticeRecord)}
评分说明
以改进方案列出的措施和首次直播AI评价报告中的问题为基准，逐条对照二次直播字幕/话术确认改进落实与否。

评分规则
1. 话术与表现优化（5分）
判定标准：
●话术修改到位
●删除所有违禁词
●补充遗漏卖点

计分规则：
●完全符合：5分
●部分符合：-2.5分（得2.5分）
●不符合：-5分（得0分）

2. 直播完成度（2分）
判定标准：
●完成完整的二次直播流程
●时长符合要求（15分钟，±5%）

计分规则：
●符合要求：2分
●不达标：-2分（得0分）

3. 语速控制改进（6分）
判定标准：
●平均语速控制在180-220字/分钟
●相比首次直播有明显改善

计分规则：
●达标且较首次优化显著：6分
●仅达标无改善：-2分（得4分）
●未达标：-3分（得3分）

语速标准参考

理想语速：180-220 字/分钟
- 观众能够轻松跟上
- 有足够时间理解信息
- 节奏舒适，不紧不慢
偏快语速：221-240 字/分钟
- 部分观众可能跟不上
- 影响信息吸收效果
- 建议适当放慢
过快语速：>240 字/分钟
- 大部分观众难以跟上
- 严重影响直播效果
- 必须改进
偏慢语速：150-179 字/分钟
- 节奏稍显拖沓
- 可能影响直播间活跃度
- 建议适当加快
过慢语速：<150 字/分钟
- 节奏过于拖沓
- 观众容易失去耐心
- 必须改进

4. 违禁词改进（5分）
判定标准：
●二次直播零违禁词
●所有表达符合平台规范
计分规则：
●零违禁词：5分
●若仍出现违禁词：直接0分，并记录违禁词
常见违禁词快速对照表
类别1：绝对化用语（共20个）
最、最佳、最好、最优、最大、最小、最新、最先进
第一、首个、首选、唯一、独一无二、前无古人
极致、完美、顶级、至尊、终极、巅峰

类别2：夸大宣传（共15个）
100%、百分百、保证、必然、绝对、肯定
立竿见影、立即见效、马上见效、即刻
永久、终身、永远、一劳永逸、彻底

类别3：医疗用语（共20个）
治疗、治愈、医治、疗效、药用、处方
抗炎、消炎、杀菌、灭菌、防癌、抗癌
降血压、降血糖、降血脂、治痤疮、祛痘、去斑
修复、再生（需谨慎使用）

类别4：虚假宣传（共10个）
国家级、世界级、全球级、宇宙级
最高级、最低价、史无前例、前所未有
销量第一、市场占有率第一

5. 卖点覆盖改进（3分）
判定标准：
●所有商品卖点覆盖率达到100%
●相比首次直播有提升

计分规则：
●覆盖率达到100%且较首次提升：3分
●缺失：-1.5分（得1.5分）
●无提升：-1分（得2分）

6. 互动技巧改进（3分）
判定标准：
●互动频次提升
●互动方式多样
●相比首次直播有明显提升

计分规则：
●符合要求且较首次提升：3分
●无提升：-1.5分（得1.5分）
●不足：-2分（得1分）

7. 促销话术改进（3分）
判定标准：
●促销话术更加自然真诚
●紧迫感营造到位
●相比首次直播有改进

计分规则：
●符合要求且较首次提升：3分
●无提升：-1.5分（得1.5分）
●明显不足：-2分（得1分）

8. 整体表现提升（3分）
判定标准：
●语言表达、状态自信度、节奏把控等整体表现有显著提升
●结合改进方案落实情况说明证据
计分规则：
●符合要求且有证据支撑：3分
●证据不足：-1.5分（得1.5分）
●无明显提升：-2分（得1分）
`
}

export const generatePrompt = (data: any) => {
  return `
  ${generateCommodityTypePrompt(data)}
  ${generateCommodityAttrsPrompt(data)}
  ${generateCommoditiesPrompt(data)}
  ${generateSpeechPrompt(data)}
  ${generatePracticeRecordPrompt(data)}
  ${generateImprovementPlanPrompt(data)}
EXAMPLE JSON OUTPUT:
{
  "commodity_type": {
    "score": 5,
    "comment": "这是评语"
  },
  "commodity_attr": {
    "score": 5,
    "comment": "这是评语"
  },
  "commodity": {
    "score": 5,
    "comment": "这是评语"
  },
  "speech": {
    "score": 5,
    "comment": "这是评语"
  },
  "practice_record1": {
    "score": 5,
    "comment": "这是评语"
  },
  "improvement_plan": {
    "score": 5,
    "comment": "这是评语"
  },
  "practice_record2": {
    "score": 5,
    "comment": "这是评语"
  },
}
`
}
