import httpRequest from '@/utils/axios'

// 获取实验详情
export function getExperiment() {
  return httpRequest.get('/api/lab/v1/experiment/once/experiment')
}

// 获取热门标签
export function getHotTags(params: { sso_id: string; number?: number }) {
  return httpRequest.get('/api/lab/v1/experiment/analyse/hot-tags', { params })
}

// 标签人数分析(TOP5)
export function getTagTop(params: { sso_id: string; number?: number }) {
  return httpRequest.get('/api/lab/v1/experiment/analyse/tag-top', { params })
}

// 用户标签数分析(TOP10)
export function getMemberTagTop(params: { sso_id: string; number?: number }) {
  return httpRequest.get('/api/lab/v1/experiment/analyse/member-tag-top', { params })
}

// 热门群组
export function getHotGroups(params: { sso_id: string; number?: number }) {
  return httpRequest.get('/api/lab/v1/experiment/analyse/hot-groups', { params })
}
// 群组人数分析(TOP5)
export function getGroupTop(params: { sso_id: string; number?: number }) {
  return httpRequest.get('/api/lab/v1/experiment/analyse/group-top', { params })
}
// 用户群组数分析(TOP10)
export function getMemberGroupTop(params: { sso_id: string; number?: number }) {
  return httpRequest.get('/api/lab/v1/experiment/analyse/member-group-top', { params })
}
