import { getIndustryList } from '../api'

export interface IndustryType {
  id: string
  name: string
  pinyin: string
}
const industryList = ref<IndustryType[]>([])
export function useIndustry() {
  async function fetchIndustryList() {
    const res = await getIndustryList()
    industryList.value = res.data.items
  }
  onMounted(() => {
    if (!industryList.value?.length) fetchIndustryList()
  })
  return { fetchIndustryList, industryList }
}
