import httpRequest from '@/utils/axios'

// 获取实验旅程中的群组列表
export function getGroupList() {
  return httpRequest.get('/api/lab/v1/experiment/itinerary/groups')
}

// 获取实验旅程中的属性列表
export function getAttrList() {
  return httpRequest.get('/api/lab/v1/experiment/itinerary/user-attr')
}

// 链接列表
export function getConnectionList() {
  return httpRequest.get('/api/lab/v1/experiment/itinerary/connections')
}

// 标签列表
export function getTagList() {
  return httpRequest.get('/api/lab/v1/experiment/itinerary/tags')
}

// 事件列表
export function getEventList() {
  return httpRequest.get('/api/lab/v1/experiment/itinerary/events')
}

// 营销资料列表
export function getMaterialList() {
  return httpRequest.get('/api/lab/v1/experiment/itinerary/marketing-materials')
}

// 获取实验旅程检索用户的结果
export function ruleQuery(data: { experiment_id: string; filters: string }) {
  return httpRequest.post('/api/resource/v1/backend/experiment-itinerary/itinerary-query', data)
}

// 获取指定群组的成员数量
export function getGroupMemberCount(params: { group_id: string }) {
  return httpRequest.get('/api/resource/v1/backend/experiment-itinerary/group-member-count', { params })
}
