import httpRequest from '@/utils/axios'

// 获取直播成绩详情
export function getScoreDetail(params?: { id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/live-student-record/detail', { params })
}

// 获取直播成绩列表
export function getScoreList(params?: { name?: string }) {
  return httpRequest.get('/api/lab/v1/experiment/live-student-record/list', { params })
}

// 导出成绩
export function exportScore(params?: { name?: string }) {
  return httpRequest.get('/api/lab/v1/experiment/live-student-record/export', { params })
}

// 更新成绩
export function updateScore(data: { id: string; check_status: number; total_score: number; score_details: string }) {
  return httpRequest.post('/api/lab/v1/experiment/live-student-record/score', data)
}

// 一键发布成绩
export function publishAll() {
  return httpRequest.post('/api/lab/v1/experiment/live-student-record/publish-all')
}
