import httpRequest from '@/utils/axios'

// 获取实验信息
export function getExperiment() {
  return httpRequest.get('/api/lab/v1/experiment/marketing-planning/experiment')
}

// 获取营销策划完成记录
export function getRecords() {
  return httpRequest.get('/api/lab/v1/experiment/marketing-planning/step-complete-records')
}

// 获取连接列表
export function getConnections() {
  return httpRequest.get('/api/lab/v1/experiment/marketing-planning/connections')
}

// 获取除了固定属性之外的其他用户属性
export function getMemberAttrs() {
  return httpRequest.get('/api/lab/v1/experiment/marketing-planning/member-attrs')
}
// 获取事件列表
export function getEvents() {
  return httpRequest.get('/api/lab/v1/experiment/marketing-planning/events')
}

// 获取当前学员步骤
export function getSteps() {
  return httpRequest.get('/api/lab/v1/experiment/marketing-planning/steps')
}

// 保存步骤
export function updateStep(data: { type: string; detail: string }) {
  return httpRequest.post('/api/lab/v1/experiment/marketing-planning/save-steps', data)
}

// 验证当前步骤是否已经评分
export function checkStep(data: { type: number }) {
  return httpRequest.post('/api/lab/v1/experiment/marketing-planning/check-step', data)
}

// 获取用户属性数据分析
export function getMemberAttrAnalysis(params: { attr_id: string; attr_type: string }) {
  return httpRequest.get('/api/lab/v1/experiment/marketing-planning/member-attr-analysis', { params })
}

// 获取用户事件数据分析
export function getMemberEventAnalysis(params: { event_id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/marketing-planning/member-event-analysis', { params })
}
