class PCMProcessor extends AudioWorkletProcessor {
  process(inputs) {
    const input = inputs[0]
    if (input.length > 0) {
      const inputData = input[0] // 取第一个通道
      const inputData16 = new Int16Array(inputData.length)

      for (let i = 0; i < inputData.length; i++) {
        // PCM 16-bit 转换
        inputData16[i] = Math.max(-1, Math.min(1, inputData[i])) * 0x7fff
      }

      // 通过 port 向主线程发送处理后的数据
      this.port.postMessage(inputData16.buffer, [inputData16.buffer])
    }

    return true // 保持处理器活跃
  }
}

registerProcessor('pcm-processor', PCMProcessor)
