import httpRequest from '@/utils/axios'

// 获取天工AI的使用详情
export function getAIUsage(params: { marketing_material_id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/marketing-ai/ai-usage-detail', { params })
}

// 天工AI-聊天
export function postAIChat(data: {
  marketing_material_id: string
  context: string
  type: number
  chart_id: string | null
}) {
  return httpRequest.post('/api/lab/v1/experiment/marketing-ai/sky-agents-chat', data)
}

// 天工3.0文字生成图片
export function postGenerateImage(data: {
  marketing_material_id: string
  context: string
  type: number
  chart_id: string | null
}) {
  return httpRequest.post('/api/lab/v1/experiment/marketing-ai/sky-agent3-generate-image', data)
}
