import httpRequest from '@/utils/axios'

// 获取学员提交的旅程配置记录
export function getStudentTripRecord() {
  return httpRequest.get('/api/lab/v1/teacher/experiment/itinerary-record')
}

// 教师评阅学员提交的旅程配置
export function checkStudentTripRecord(data: { itinerary_id: string; score: number; graph: string; comment: string }) {
  return httpRequest.post('/api/lab/v1/teacher/experiment/check-itinerary-record', data)
}

// 保存实验旅程的评论
export function submitStudentTripRecordComment(data: { itinerary_id: string; comment: string }) {
  return httpRequest.post('/api/lab/v1/teacher/experiment/save-itinerary-comment', data)
}
