import httpRequest from '@/utils/axios'

// 获取实验直播的列表
export function getTestList(params?: {
  live_commodity_id?: string
  live_commodity_type_id?: string
  live_commodity_title?: string
}) {
  return httpRequest.get('/api/lab/v1/experiment/live-practice/list', { params })
}

// 获取实验直播详情
export function getTest(params: { id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/live-practice/detail', { params })
}

// 创建实验直播
export function createTest(data: { pid: string; name: string; status: string }) {
  return httpRequest.post('/api/lab/v1/experiment/live-practice/create', data)
}

// 更新实验直播详情
export function updateTest(data: { id: string; name: string; status: string }) {
  return httpRequest.post('/api/lab/v1/experiment/live-practice/update', data)
}

// 删除实验直播
export function deleteTest(data: { id: string }) {
  return httpRequest.post('/api/lab/v1/experiment/live-practice/delete', data)
}

// 获取实验直播话术的列表
export function getTalkList(params?: {
  name?: string
  live_commodity_id?: string
  live_commodity_type_id?: string
  live_commodity_title?: string
}) {
  return httpRequest.get('/api/lab/v1/experiment/live-speeches/list', { params })
}

// 更新实验直播详情
export function saveTestRecord(data: {
  id?: string
  live_practice_id: string
  live_start_time: string
  live_end_time: string
  live_duration?: string
  live_video_addres?: string
  live_info?: string
}) {
  return httpRequest.post('/api/lab/v1/experiment/live-practice/save-live-practice-record', data)
}

// 获取直播训练记录列表
export function getRecordList(params: { live_practice_id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/live-practice/live-practice-records', { params })
}

// 获取直播训练记录列表
export function getRecord(params: { id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/live-practice/live-practice-record', { params })
}

// 推送字幕
export function pushSubtitle(params: { subtitle: string; selling_point: string; marketing_campaign: string }) {
  return httpRequest.get('/api/lab/v1/experiment/live-practice/push-subtitle', { params })
}

// 更新改进方案
export function updateImprovementPlan(data: { id: string; improvement_plan: string }) {
  return httpRequest.post('/api/lab/v1/experiment/live-practice/submit-improvement-plan', data)
}

// AI 打分
export function aiScore(data: { id: string }) {
  return httpRequest.post('/api/lab/v1/experiment/live-practice/score-live-practice-record', data)
}
