import type { IMenuItem } from '@/types'
import { defineStore } from 'pinia'
import { useUserStore } from '@/stores/user'
import { Document, DocumentChecked } from '@element-plus/icons-vue'

import IconMetadata from '@/components/icon/IconMetadata.vue'
import IconConnect from '@/components/icon/IconConnect.vue'
import IconUser from '@/components/icon/IconUser.vue'
import IconGroup2 from '@/components/icon/IconGroup2.vue'
import IconUser2 from '@/components/icon/IconUser2.vue'
import IconLabel from '@/components/icon/IconLabel.vue'
import IconGroup from '@/components/icon/IconGroup.vue'
import IconMaterial from '@/components/icon/IconMaterial.vue'
import IconTrip from '@/components/icon/IconTrip.vue'
import IconAnalyze from '@/components/icon/IconAnalyze.vue'
import IconText from '@/components/icon/IconText.vue'
import IconImage from '@/components/icon/IconImage.vue'
import IconAudio from '@/components/icon/IconAudio.vue'
import IconVideo from '@/components/icon/IconVideo.vue'
import IconH5 from '@/components/icon/IconH5.vue'
import IconQrcode from '@/components/icon/IconQrcode.vue'
import IconMiniProgram from '@/components/icon/IconMiniProgram.vue'
import IconCard from '@/components/icon/IconCard.vue'
import IconEvent from '@/components/icon/IconEvent.vue'
import IconMarket from '@/components/icon/IconMarket.vue'
import IconLive from '@/components/icon/IconLive.vue'
import IconLiveProductCategory from '@/components/icon/IconLiveProductCategory.vue'
import IconLiveProductAttr from '@/components/icon/IconLiveProductAttr.vue'
import IconLiveProductManagement from '@/components/icon/IconLiveProductManagement.vue'
import IconLiveTalk from '@/components/icon/IconLiveTalk.vue'
import IconLiveTest from '@/components/icon/IconLiveTest.vue'

interface State {
  studentMenus: IMenuItem[]
  adminMenus: IMenuItem[]
}

// 学生菜单
const studentMenus: IMenuItem[] = [
  {
    id: 1,
    name: '基础配置',
    path: '/connect',
    icon: markRaw(IconMetadata),
    children: [
      {
        id: 2,
        name: '连接管理',
        path: '/connect',
        icon: markRaw(IconConnect),
      },
    ],
  },
  {
    id: 5,
    name: '营销策划',
    path: '/market/my',
    icon: markRaw(IconMarket),
  },
  {
    id: 6,
    name: '用户画像',
    path: '/user',
    icon: markRaw(IconUser),
  },
  {
    id: 7,
    name: '用户识别',
    path: '/label',
    icon: markRaw(IconGroup2),
    children: [
      {
        id: 8,
        name: '标签管理',
        path: '/label',
        icon: markRaw(IconLabel),
      },
      {
        id: 9,
        name: '群组管理',
        path: '/group',
        icon: markRaw(IconGroup),
      },
    ],
  },
  {
    id: 10,
    name: '营销内容设计',
    path: '/material',
    icon: markRaw(IconMaterial),
    children: [
      {
        id: 11,
        name: '文本资料管理',
        path: '/material?type=1',
        icon: markRaw(IconText),
        // tag: 'v1-experiment-marketing-material-list'
        tag: '',
      },
      {
        id: 12,
        name: '图片资料管理',
        path: '/material?type=2',
        icon: markRaw(IconImage),
        // tag: 'v1-experiment-marketing-material-list'
        tag: '',
      },
      {
        id: 13,
        name: '卡券资料管理',
        path: '/material?type=8',
        icon: markRaw(IconCard),
        // tag: 'v1-experiment-marketing-material-list'
        tag: '',
      },
      {
        id: 17,
        name: '语音资料管理',
        path: '/material?type=3',
        icon: markRaw(IconAudio),
        // tag: 'v1-experiment-marketing-material-list'
        tag: '',
      },
      {
        id: 14,
        name: '视频资料管理',
        path: '/material?type=4',
        icon: markRaw(IconVideo),
        // tag: 'v1-experiment-marketing-material-list'
        tag: '',
      },
      {
        id: 15,
        name: 'H5资料管理',
        path: '/material?type=5',
        icon: markRaw(IconH5),
        // tag: 'v1-experiment-marketing-material-list',
      },
      {
        id: 16,
        name: '二维码资料管理',
        path: '/material?type=6',
        icon: markRaw(IconQrcode),
        // tag: 'v1-experiment-marketing-material-list'
        tag: '',
      },
      {
        id: 18,
        name: '小程序资料管理',
        path: '/material?type=7',
        icon: markRaw(IconMiniProgram),
        // tag: 'v1-experiment-marketing-material-list'
        tag: '',
      },
    ],
  },
  {
    id: 19,
    name: '自动化营销',
    path: '/trip/my',
    icon: markRaw(IconTrip),
  },
  {
    id: 20,
    name: '直播',
    path: '/live',
    icon: markRaw(IconLive),
    children: [
      {
        id: 23,
        name: '商品管理',
        path: '/live/product/management',
        icon: markRaw(IconLiveProductManagement),
      },
      { id: 24, name: '直播话术管理', path: '/live/talk', icon: markRaw(IconLiveTalk) },
      { id: 25, name: '直播', path: '/live/test', icon: markRaw(IconLiveTest) },
    ],
  },
  {
    id: 26,
    name: '数据分析',
    path: '/analyze',
    icon: markRaw(IconAnalyze),
    children: [
      { id: 27, name: '用户分析', path: '/analyze/user' },
      { id: 28, name: '标签群组分析', path: '/analyze/label' },
      { id: 29, name: '事件分析', path: '/analyze/event' },
      { id: 30, name: '营销分析', path: '/analyze/marketing' },
    ],
  },
]

const adminMenus: IMenuItem[] = [
  {
    id: 1,
    name: '基础配置',
    path: '/connect',
    icon: markRaw(IconMetadata),
    children: [
      {
        id: 2,
        name: '连接管理',
        path: '/connect',
        icon: markRaw(IconConnect),
        // tag: 'v1-experiment-connection',
      },
      {
        id: 3,
        name: '用户属性管理',
        path: '/metadata/user',
        icon: markRaw(IconUser2),
        // tag: 'v1-experiment-meta-member',
      },
      {
        id: 4,
        name: '事件属性管理',
        path: '/metadata/event',
        icon: markRaw(IconEvent),
        // tag: 'v1-experiment-meta-event',
      },
    ],
  },
  {
    id: 5,
    name: '营销策划',
    path: '/market/review',
    studentPath: '/market/my',
    icon: markRaw(IconMarket),
  },
  {
    id: 6,
    name: '用户画像',
    path: '/user',
    icon: markRaw(IconUser),
    // tag: 'v1-experiment-member',
  },
  {
    id: 7,
    name: '用户识别',
    path: '/label',
    icon: markRaw(IconGroup2),
    children: [
      {
        id: 8,
        name: '标签管理',
        path: '/label',
        icon: markRaw(IconLabel),
        // tag: 'experiment_tags',
      },
      {
        id: 9,
        name: '群组管理',
        path: '/group',
        icon: markRaw(IconGroup),
        // tag: 'experiment_groups',
      },
      {
        id: 71,
        name: '运营策略管理',
        path: '/strategy',
        icon: markRaw(IconLiveTalk),
        // tag: 'experiment_groups',
      },
    ],
  },
  {
    id: 10,
    name: '营销内容设计',
    path: '/material',
    icon: markRaw(IconMaterial),
    // tag: 'v1-experiment-marketing-material',
    children: [
      {
        id: 11,
        name: '文本资料管理',
        path: '/material?type=1',
        icon: markRaw(IconText),
        // tag: 'v1-experiment-marketing-material-list',
      },
      {
        id: 12,
        name: '图片资料管理',
        path: '/material?type=2',
        icon: markRaw(IconImage),
        // tag: 'v1-experiment-marketing-material-list',
      },
      {
        id: 13,
        name: '卡券资料管理',
        path: '/material?type=8',
        icon: markRaw(IconCard),
        // tag: 'v1-experiment-marketing-material-list',
      },
      {
        id: 17,
        name: '语音资料管理',
        path: '/material?type=3',
        icon: markRaw(IconAudio),
        // tag: 'v1-experiment-marketing-material-list',
      },
      // {
      //   id: 14,
      //   name: '数字人管理',
      //   path: '/material/digital-human',
      //   icon: markRaw(IconVideo),
      //   // tag: 'v1-experiment-marketing-material-list',
      // },
      {
        id: 14,
        name: '视频资料管理',
        path: '/material?type=4',
        icon: markRaw(IconVideo),
        // tag: 'v1-experiment-marketing-material-list',
      },
      {
        id: 15,
        name: 'H5资料管理',
        path: '/material?type=5',
        icon: markRaw(IconH5),
        // tag: 'v1-experiment-marketing-material-list',
      },
      {
        id: 16,
        name: '二维码资料管理',
        path: '/material?type=6',
        icon: markRaw(IconQrcode),
        // tag: 'v1-experiment-marketing-material-list',
      },
      {
        id: 18,
        name: '小程序资料管理',
        path: '/material?type=7',
        icon: markRaw(IconMiniProgram),
        // tag: 'v1-experiment-marketing-material-list',
      },
    ],
  },
  {
    id: 19,
    name: '自动化营销',
    path: '/trip',
    studentPath: '/trip/my',
    icon: markRaw(IconTrip),
    // tag: 'experiment_itinerary',
    // children: [{ name: '旅程模板管理', path: '/trip/template', tag: 'experiment_itinerary_list' }]
  },
  {
    id: 20,
    name: '直播',
    path: '/live',
    icon: markRaw(IconLive),
    children: [
      {
        id: 21,
        name: '商品品类管理',
        path: '/live/product/category',
        icon: markRaw(IconLiveProductCategory),
        // role: [5, 6],
      },
      {
        id: 22,
        name: '商品属性管理',
        path: '/live/product/attr',
        icon: markRaw(IconLiveProductAttr),
        // role: [5, 6]
      },
      {
        id: 23,
        name: '商品管理',
        path: '/live/product/management',
        icon: markRaw(IconLiveProductManagement),
        // role: [5, 6],
      },
      { id: 24, name: '直播话术管理', path: '/live/talk', icon: markRaw(IconLiveTalk) },
      { id: 25, name: '直播', path: '/live/test', icon: markRaw(IconLiveTest) },
      { id: 201, name: '订单管理', path: '/live/order', icon: markRaw(IconCard) },
      { id: 202, name: '直播总结管理', path: '/live/reports', icon: markRaw(Document) },

      {
        id: 203,
        name: '成绩管理',
        path: '/live/score',
        icon: markRaw(DocumentChecked),
        role: [5, 6],
      },
    ],
  },
  {
    id: 26,
    name: '数据分析',
    path: '/analyze',
    icon: markRaw(IconAnalyze),
    children: [
      { id: 27, name: '用户分析', path: '/analyze/user' },
      { id: 28, name: '标签群组分析', path: '/analyze/label' },
      { id: 29, name: '事件分析', path: '/analyze/event' },
      { id: 30, name: '营销分析', path: '/analyze/marketing' },
    ],
  },
]

export const useMenuStore = defineStore({
  id: 'menu',
  state: (): State => ({
    studentMenus,
    adminMenus,
  }),
  getters: {
    menus: (state) => {
      const userStore = useUserStore()
      const userRole = userStore.role?.id || 1
      const userPermissions = userStore.menus || []

      // 递归过滤菜单及其子菜单
      const filterMenus = (menus: IMenuItem[]): IMenuItem[] => {
        return menus
          .filter((menu) => userPermissions.some((perm) => perm.id === menu.id))
          .filter((menu) => (menu.role ? menu.role?.includes(userRole) : true))
          .map((menu) => {
            const filteredMenu: IMenuItem = {
              ...menu,
              // 替换路径为学生路径（如果有学生路径并且角色为学生）
              path: userRole === 1 && menu.studentPath ? menu.studentPath : menu.path,
            }
            // 如果存在子菜单，则递归过滤
            if (menu.children) {
              filteredMenu.children = filterMenus(menu.children)
            }
            return filteredMenu
          })
      }

      // 根据用户角色选择基础菜单
      // const baseMenus = userRole === 1 ? state.studentMenus : state.adminMenus
      return filterMenus(state.adminMenus)
    },
  },
})
