import type { RouteRecordRaw } from 'vue-router'
import Layout from '@/components/layout/Index.vue'

const routes: RouteRecordRaw[] = [
  {
    path: '/live/score',
    component: Layout,
    children: [
      { path: '', component: () => import('./views/Index.vue') },
      { path: 'view', component: () => import('./views/View.vue') },
    ],
  },
  {
    path: '/operations/score',
    component: Layout,
    children: [
      { path: '', component: () => import('./views/Index.vue'), props: { hasAI: false } },
      { path: 'view', component: () => import('./views/View.vue') },
    ],
  },
]

export { routes }
