import type { GraphEdge, GraphNode } from '@vue-flow/core'
import { ruleQuery } from '@/api/flow'
import { useVueFlow } from '@vue-flow/core'

function sortEdges(source: string, edges: GraphEdge[]) {
  const resultEdges = []
  let edge
  while ((edge = edges.find(edge => edge.target === source))) {
    resultEdges.unshift(edge)
    source = edge?.source
  }
  return resultEdges
}

function sortNodes(source: string, edges: GraphEdge[], nodes: GraphNode[]) {
  const findNode = (source: string) => nodes.find(node => node.id === source)
  const result = []
  edges.forEach(edge => {
    const node = findNode(edge.source)
    if (node) result.push(node)
  })
  const node = findNode(source)
  if (node) result.push(node)
  return result
}

const total = ref()

export function useQueryUser(node: any) {
  const route = useRoute()
  const { nodes, edges } = useVueFlow()
  const expectedTotal = ref()

  onMounted(async () => {
    if (!total.value) {
      const { data } = await ruleQuery({ experiment_id: route.query.experiment_id as string, filters: '' })
      total.value = data.count
    }
  })

  async function query() {
    const prevEdges = sortEdges(node.id, edges.value)
    const prevNodes = sortNodes(node.id, prevEdges, nodes.value)
    const filters = prevNodes.map(node => ({
      type: node.data.type,
      component_type: node.data.component_type,
      search_mode: 1,
      params: node.data.rule_params || {}
    }))
    const { data } = await ruleQuery({
      experiment_id: route.query.experiment_id as string,
      filters: JSON.stringify(filters)
    })
    expectedTotal.value = data.count
  }

  // 上一节点
  const prevNode = computed(() => {
    const prevEdges = sortEdges(node.id, edges.value)
    const prevNodes = sortNodes(node.id, prevEdges, nodes.value)
    return prevNodes[prevNodes.length - 2]
  })

  const prevNodeRule = computed(() => {
    return prevNode.value?.data?.rule ?? {}
  })

  // 上一节点预期用户数量
  const prevNodeExpectedTotal = computed(() => {
    return prevNodeRule.value?.expected_user_total ?? 0
  })

  return { total, expectedTotal, prevNode, prevNodeRule, prevNodeExpectedTotal, query }
}
