import { createApp } from 'vue'
import { createPinia } from 'pinia'

import App from './App.vue'
import router from './router'

import ElementPlus from 'element-plus'
import '@/assets/styles/element/index.scss'
import zhCn from 'element-plus/es/locale/lang/zh-cn'
import AppCard from '@/components/base/AppCard.vue'
import AppList from '@/components/base/AppList.vue'

import modules from './modules'

import { permissionDirective } from '@/utils/permission'

const app = createApp(App)
// 注册公共组件
app.component('AppCard', AppCard).component('AppList', AppList)
app.directive('permission', permissionDirective)
// 注册模块
modules({ router })

app.use(createPinia())
app.use(router)
app.use(ElementPlus, { locale: zhCn })

app.mount('#app')
