export const systemPrompt = `你是一位专业的直播电商分析师，现在需要你基于我给你的输入信息，为直播练习生成一份全面、详细、准确的直播评价报告。
**核心要求：**
1. 所有数据统计必须基于实际输入内容进行精确计算，不得估算或编造
2. 严格遵循输出格式规范，保持结构一致性
3. 分析客观专业，建议具体可执行`

export const getUserPrompt = (detail: any) => `
一、输入信息
- 直播时长：${detail.live_duration}秒
- 字幕文本：${detail.subtitle}
- 直播话术脚本：${detail.live_practice_info.live_speech.content}
- 预设卖点：${detail.live_practice_info.live_speech.selling_point}
- 营销活动：${detail.live_practice_info.live_speech.marketing_campaign}
- 商品信息：${JSON.stringify(detail.live_practice_info.live_commodity)}

二、输出要求与规则
2.1 输出格式
JSON 结构（必须严格遵守）：

{
  "sellingPoints": "...卖点讲解覆盖情况的完整 Markdown 内容...",
  "forbiddenWords": "...违禁词分析报告的完整 Markdown 内容...",
  "speechSpeed": "...语速分析报告的完整 Markdown 内容...",
  "optimizationTips": "...直播优化建议的完整 Markdown 内容..."
}

注意：

四个字段必须全部返回，值为字符串类型

每个字段的值为对应板块的完整 Markdown 内容

不允许修改字段名称，以保证前端对接一致性

2.2 数据统计规则（重要）
规则 1：口播字数统计
统计方法：

基于【字幕文本】内容进行统计

统计所有汉字、字母、数字的总数（不含标点符号和空格）

计算公式：口播字数 = len(re.sub(r'[^\w\u4e00-\u9fff]', '', 字幕文本))

示例：

字幕文本："大家好，欢迎来到直播间！今天给大家带来一款超值面膜。"

口播字数：25 字（不含标点和空格）

规则 2：卖点讲解判断标准
判断方法：

逐一对比【预设卖点】和【字幕文本】

如果字幕中出现卖点的关键词（至少 3 个连续汉字匹配），则认为该卖点已讲解

如果卖点被提及且有相关描述（超过 15 字），则认为是有效讲解

示例：

预设卖点："三重玻尿酸深层补水"

字幕中出现："这款面膜含有三重玻尿酸，能够深层补水" → 已讲解 ✓

字幕中出现："含有玻尿酸成分" → 未充分讲解 ✗（描述不足 15 字）

覆盖率计算：


覆盖率 = (已讲解卖点数量 / 预设卖点总数量) × 100%

规则 3：语速计算规则
计算方法：

基于【字幕文本】和【直播时长】计算

平均语速 = 口播字数 ÷ 直播时长（分钟）

分段语速：将直播时长按分钟切分，分别统计每分钟的字数

示例：

直播时长：15 分钟

口播字数：3000 字

平均语速：3000 ÷ 15 = 200 字/分钟

语速评价标准：

✅ 正常：180-220 字/分钟

⚡ 偏快：221-240 字/分钟

❌ 过快：>240 字/分钟

⚠️ 偏慢：150-179 字/分钟

❌ 过慢：<150 字/分钟

规则 4：违禁词检测规则
检测方法：

基于【违禁词对照表】逐个检测【字幕文本】
如果【字幕文本】里面包含了【违禁词对照表】里面的违禁词，则记录下每个违禁词的出现位置、次数、上下文
标注违禁词在原文中的位置（使用 ↑违禁 标记） 违禁词对照表： 最、最佳、最好、最优、最大、最小、最新、最先进、第一、首个、首选、唯一、独一无二、前无古人、极致、完美、顶级、至尊、终极、巅峰、100%、百分百、保证、必然、绝对、肯定、立竿见影、立即见效、马上见效、即刻、永久、终身、永远、一劳永逸、彻底、治疗、治愈、医治、疗效、药用、处方、抗炎、消炎、杀菌、灭菌、防癌、抗癌、降血压、降血糖、降血脂、治痤疮、祛痘、去斑、修复、再生、国家级、世界级、全球级、宇宙级、最高级、最低价、史无前例、前所未有、销量第一、市场占有率第一 严重程度评估标准：
严重：≥5 个违禁词
中等：3-4 个违禁词
轻微：1-2 个违禁词
零违禁：0 个违禁词
零违禁：0 个违禁词

三、输出示例
示例 1：sellingPoints（卖点讲解覆盖情况）

## 卖点讲解覆盖情况

 

### 卖点讲解综合评价

 

**【整体表现】**

 

本次直播时长 15 分钟，累计口播 2847 字，平均语速约 190 字/分钟。本次直播共讲解了 4 个卖点，覆盖率达到 80%（预设 5 个卖点）。

 

**已讲解卖点：**

1. ✅ 三重玻尿酸深层补水（讲解时长约 45 秒，内容充分）

2. ✅ 烟酰胺提亮肤色（讲解时长约 30 秒，内容充分）

3. ✅ 48 小时持久保湿（讲解时长约 35 秒，内容充分）

4. ✅ 医研共创配方（讲解时长约 25 秒，内容简略）

 

**未讲解卖点：**

1. ❌ 神经酰胺和角鲨烷修护屏障（完全未提及）

 

**整体评价：**

卖点讲解较为全面，重点突出，但遗漏了"神经酰胺和角鲨烷"这一重要卖点。前 3 个卖点讲解深入，但第 4 个卖点"医研共创配方"仅简单带过，缺乏具体说明。建议在二次直播中补充遗漏卖点，并对"医研共创配方"进行更详细的讲解，增加品牌背书和专业性。

示例 2：forbiddenWords（违禁词分析报告）
情况 A：发现违禁词


## 违禁词分析报告

 

### 检测结果总览

 

- **共发现**：3 个违禁词/敏感词

- **严重程度评估**：轻微

 

---

 

### 违禁词详细列表

 

**【违禁词 #1】**

━━━━━━━━━━━━

- **违禁词**："最好"

- **类型**：绝对化用语

- **出现时间**：第 3 分 25 秒

- **出现次数**：1 次

- **上下文原文**："这款面膜效果最好,市场上独一无二的配方..."

↑违禁    ↑违禁

 

**【违禁词 #2】**

━━━━━━━━━━━━

- **违禁词**："独一无二"

- **类型**：绝对化用语

- **出现时间**：第 3 分 27 秒

- **出现次数**：1 次

- **上下文原文**："这款面膜效果最好,市场上独一无二的配方..."

↑违禁    ↑违禁

 

**【违禁词 #3】**

━━━━━━━━━━━━

- **违禁词**："100%"

- **类型**：夸大宣传

- **出现时间**：第 8 分 15 秒

- **出现次数**：1 次

- **上下文原文**："使用后 100% 能看到效果,保证满意..."

↑违禁         ↑违禁

 

---

 

### 违规情况统计

 

- **违禁词总数**：3 个

- **违禁词出现总次数**：3 次

 

**类型分布：**

- 绝对化用语：2 个（最好、独一无二）

- 夸大宣传：1 个（100%）

- 医疗用语：0 个

- 虚假宣传：0 个

 

**高频违禁词：**

1. "最好" - 出现 1 次

2. "独一无二" - 出现 1 次

3. "100%" - 出现 1 次

情况 B：零违禁（无违禁词）


## 违禁词分析报告

 

### 检测结果总览

 

- **共发现**：0 个违禁词/敏感词

- **严重程度评估**：零违禁

 

**【评价】**

本次直播用词规范，未发现任何违禁词或敏感词，合规性良好。继续保持专业、准确的表达方式。

示例 3：speechSpeed（语速分析报告）

## 语速分析报告

 

### （一）语速分析

 

**整体语速数据：**

- **平均语速**：195 字/分钟

- **最快语速**：258 字/分钟（出现在第 5 分 30 秒）

- **最慢语速**：142 字/分钟（出现在第 9 分 15 秒）

- **语速波动**：±35 字/分钟（标准差）

 

---

 

### （二）语速标准参考

 

1. **理想语速**：180-220 字/分钟 ✅

2. **偏快语速**：221-240 字/分钟 ⚡

3. **过快语速**：>240 字/分钟 ❌

4. **偏慢语速**：150-179 字/分钟 ⚠️

5. **过慢语速**：<150 字/分钟 ❌

 

---

 

### （三）语速曲线分析

 

**【语速统计区间】**

 

| 时间段 | 语速(字/分) | 评价 | 对应环节 |

|:---:|:---:|:---:|:---:|

| 00:00-01:00 | 188 | ✅正常 | 开场白 |

| 01:00-02:00 | 192 | ✅正常 | 品牌介绍 |

| 02:00-03:00 | 165 | ⚠️偏慢 | 品牌介绍 |

| 03:00-04:00 | 195 | ✅正常 | 产品讲解-开始 |

| 04:00-05:00 | 225 | ⚡偏快 | 产品讲解-成分 |

| 05:00-06:00 | 258 | ❌过快 | 产品讲解-卖点 |

| 06:00-07:00 | 210 | ✅正常 | 产品讲解-效果 |

| 07:00-08:00 | 198 | ✅正常 | 产品讲解-价格 |

| 08:00-09:00 | 155 | ⚠️偏慢 | 互动环节 |

| 09:00-10:00 | 235 | ⚡偏快 | 促销推动 |

| 10:00-11:00 | 228 | ⚡偏快 | 促销推动 |

| 11:00-12:00 | 205 | ✅正常 | 催单话术 |

| 12:00-13:00 | 190 | ✅正常 | 组合优惠 |

| 13:00-14:00 | 185 | ✅正常 | 结束语 |

| 14:00-15:00 | 178 | ⚠️偏慢 | 结束语 |

 

---

 

### （四）语速异常时间段详细分析

 

**【异常片段 #1】**

━━━━━━━━━━━━

- **时间**：05:00-06:00（1 分钟）

- **问题**：语速过快

- **数据**：258 字/分钟（超标准 38 字/分钟）

- **对应内容**：产品卖点讲解-三重玻尿酸成分介绍

 

**【异常片段 #2】**

━━━━━━━━━━━━

- **时间**：09:00-11:00（2 分钟）

- **问题**：持续偏快

- **数据**：231 字/分钟（超标准 11 字/分钟）

- **对应内容**：促销推动环节

 

**【异常片段 #3】**

━━━━━━━━━━━━

- **时间**：02:00-03:00（1 分钟）

- **问题**：语速偏慢

- **数据**：165 字/分钟（低于标准 15 字/分钟）

- **对应内容**：品牌介绍环节

 

**【异常片段 #4】**

━━━━━━━━━━━━

- **时间**：08:00-09:00（1 分钟）

- **问题**：语速偏慢

- **数据**：155 字/分钟（低于标准 25 字/分钟）

- **对应内容**：互动环节

 

---

 

### （五）语速变化趋势分析

 

**【整体趋势】**

 

本次直播语速呈现"波浪形"变化。开场语速正常（188-192 字/分钟），品牌介绍后段出现偏慢（165 字/分钟）。在产品讲解环节（4-6 分钟）明显加快，尤其在卖点讲解时达到 258 字/分钟的峰值。互动环节放慢至 155 字/分钟，促销环节再次加快至 231 字/分钟，结束语恢复正常但略显拖沓（178 字/分钟）。整体语速波动较大（±35 字/分钟），稳定性不足。

 

**【问题诊断】**

 

- **主要问题**：在需要重点讲解的环节（产品卖点）语速反而过快（258 字/分钟），导致观众难以吸收关键信息，影响转化效果。

- **次要问题**：语速波动过大（±35 字/分钟），缺乏整体节奏控制，部分环节过快、部分环节过慢，观看体验不够流畅。

示例 4：optimizationTips（直播优化建议）

## 直播优化建议

 

### 综合评价

 

本次直播整体表现良好，在卖点讲解和品牌介绍方面表现突出，但在语速控制、互动频率和促单技巧方面还有较大提升空间。以下从 5 个维度提出具体优化建议：

 

---

 

### 1、语速与节奏

 

**【现状描述】**

 

平均语速约 195 字/分钟，整体适中。但在产品讲解环节（4-6 分钟）语速明显过快，达到 258 字/分钟，在互动环节又过于缓慢（155 字/分钟）。语速波动较大（±35 字/分钟），节奏不够稳定。

 

**【存在问题】**

 

- **问题 1**：产品讲解环节（5:00-6:00）语速过快，达到 258 字/分钟，观众可能跟不上，尤其是"三重玻尿酸"等专业术语

- **问题 2**：停顿不当，在关键卖点"48 小时持久保湿"后没有留出思考时间，直接进入下一个卖点

- **问题 3**：节奏不稳定，从产品讲解的 258 字/分钟突然降到互动环节的 155 字/分钟，时快时慢，影响观看体验

 

**【改进建议】**

 

- **具体建议 1**：在讲解"三重玻尿酸成分"等专业内容时，有意识放慢语速至 200 字/分钟以内，并在关键数据（如"48 小时"）后停顿 1-2 秒，让观众充分理解

- **具体建议 2**：使用"那么"、"接下来"、"大家注意"等连接词自然控制节奏，在卖点之间增加过渡，避免讲解过于密集

- **具体建议 3**：提前充分练习话术脚本，熟记核心内容，避免因不熟练导致语速失控。建议每天练习 2-3 遍，直到能够流畅表达

 

---

 

### 2、互动能力

 

**【现状描述】**

 

互动频率不足，整场 15 分钟直播共发起 3 次互动，回应了 1 条观众评论。互动形式单一，主要为"点赞破万送福利"，缺乏创意和吸引力。

 

**【存在问题】**

 

- **问题 1**：互动频率过低，平均每 5 分钟才有 1 次互动，直播间氛围不够活跃，观众参与感不强

- **问题 2**：互动问题设计不够吸引人，"点赞破万"的门槛过高（当前仅 3500 点赞），观众参与度不高

- **问题 3**：对观众评论回应不够及时，评论区有 5 条"敏感肌能用吗"的提问，但直播中未及时回应，错过了互动机会

- **问题 4**：抽奖活动执行不到位，仅在开场提了一次"点赞破万抽奖"，后续未再强调，未能充分调动观众积极性

 

**【改进建议】**

 

- **具体建议 1**：增加互动频率，建议每 3-5 分钟发起一次互动，如"有宝宝用过玻尿酸面膜吗？效果如何？扣 1 分享一下"

- **具体建议 2**：设计更有趣的互动问题和阶梯式目标，如"猜猜这款面膜的秒杀价是多少？猜中送小样！"或"点赞 5000 抽 1 人，点赞 8000 抽 3 人"

- **具体建议 3**：安排专人实时监控评论区，对高频问题立即回应，如"敏感肌能用吗？可以的，这款面膜不含酒精和香精，敏感肌友好"

- **具体建议 4**：在点赞数接近目标时，实时播报进度并强调"还差 500 个就到 5000 啦，大家帮忙点一下，马上抽奖！"营造紧迫感和参与感

 

---

 

### 3、卖点讲解能力

 

**【现状描述】**

 

共讲解了 4 个卖点，覆盖率 80%（预设 5 个）。讲解较为清晰，逻辑性强，但遗漏了 1 个重要卖点，部分卖点讲解深度不够。

 

**【存在问题】**

 

- **问题 1**：卖点讲解不够深入，对"三重玻尿酸"的概念仅说"含有三重玻尿酸"，未解释"大中小分子"的具体作用

- **问题 2**：缺少具体案例和数据支撑，"48 小时持久保湿"未引用"真人实测数据"，说服力不足

- **问题 3**：遗漏重要卖点"神经酰胺和角鲨烷修护屏障"，导致产品价值传达不完整

- **问题 4**："医研共创配方"仅简单带过，未说明具体合作机构或背书，专业性不足

 

**【改进建议】**

 

- **具体建议 1**：讲解"三重玻尿酸"时,要详细说明"大中小分子玻尿酸,分别作用于肌肤不同层次:大分子在表面锁水、中分子在中层补水、小分子深层渗透"

- **具体建议 2**：引用具体数据增强说服力，如"真人实测 48 小时后肌肤水润度依然提升 40%，持久保湿看得见"

- **具体建议 3**：补充遗漏卖点，在下次直播中加入"神经酰胺和角鲨烷双重修护，强韧肌肤屏障，敏感肌也能安心用"

- **具体建议 4**：将所有 5 个卖点都讲解到位，每个卖点至少讲解 30 秒，按照"成分→功效→效果→数据支撑"的逻辑顺序展开

 

---

 

### 4、促单能力

 

**【现状描述】**

 

促单环节共 2 次（8 分钟和 10 分钟各 1 次），促单话术包括"秒杀价 69 元"和"限时限量"。促单话术力度一般，缺乏紧迫感营造。

 

**【存在问题】**

 

- **问题 1**：促单话术力度不够，缺乏紧迫感营造，仅说"秒杀价 69 元"，未强调"限时"和"限量"

- **问题 2**：未充分强调价格优惠对比，"秒杀价 69 元"只提了 1 次，未与原价 99 元形成对比，价值感不足

- **问题 3**：限时限量信息传达不清，未说明"秒杀还剩多少时间"、"还剩多少库存"，未能激发购买欲望

- **问题 4**：组合优惠活动讲解不够清晰，"买 10 片装送 2 片"未强调"相当于 12 片只要 69 元"，观众可能不理解优惠力度

 

**【改进建议】**

 

- **具体建议 1**：在秒杀环节强调紧迫感，"只剩最后 5 分钟！只有 100 份！现在还剩 37 份！手慢无！"配合倒计时营造氛围

- **具体建议 2**：多次强调价格对比，"平时 99 元，今天秒杀只要 69 元，一片才 6.9 元，比超市便宜一半，太划算了！"

- **具体建议 3**：在促销环节使用催单话术，实时播报"已经有 156 位宝宝下单了，还在犹豫的宝宝抓紧啦！"营造从众心理

- **具体建议 4**：清晰讲解组合优惠，"买 10 片装送 2 片，相当于 12 片只要 69 元，平均一片不到 6 块钱，比单买划算多了！"

 

---

 

### 5、整体表现力

 

**【现状描述】**

 

仪表整洁，妆容得体，符合直播要求。肢体语言略显僵硬，镜头感一般，眼神交流不够。整体略显紧张，自信度有待提升。

 

**【存在问题】**

 

- **问题 1**：肢体语言不够丰富，全程较为僵硬，双手多数时间放在身体两侧，缺乏手势配合

- **问题 2**：眼神交流不够，经常低头看脚本或商品，与镜头（观众）的眼神交流不足，亲和力不够

- **问题 3**：产品展示不够充分，讲解"三重玻尿酸"时未将产品包装靠近镜头展示成分表和文字说明

- **问题 4**：整体略显紧张，语气不够自信，多次出现"嗯"、"那个"等口头禅，影响专业度

 

**【改进建议】**

 

- **具体建议 1**：增加手势配合讲解，如讲"三重玻尿酸"时用手势比划"三层"，讲"深层补水"时做由外向内的手势，增强表现力

- **具体建议 2**：尽量看镜头而不是脚本，熟记话术核心内容，眼神交流要自然，把镜头想象成一位朋友，用对话的方式讲解

- **具体建议 3**：展示产品时，将产品正面靠近镜头 5-10 秒，展示包装细节、品牌 logo 和成分表文字说明，增强信任感

- **具体建议 4**：直播前做好充分准备，深呼吸放松，告诉自己"我准备充分，一定可以"。减少口头禅，可以用短暂停顿代替"嗯"、"那个"

四、特别注意事项
4.1 数据准确性要求
严格统计：所有数字必须基于实际输入数据精确计算，不得估算

逻辑一致：卖点覆盖率、语速数据、违禁词数量必须前后一致

可验证性：统计结果应可通过输入数据反向验证

4.2 格式规范要求
标题层级：严格按照示例中的标题层级（#、##、###）输出

符号一致：使用相同的分隔符（━━━）和图标（✅、❌、⚡、⚠️）

表格对齐：表格内容居中对齐（:---: 语法）

不增不减：不允许新增或删除节点，保持结构一致

4.3 零违禁词特殊处理
当违禁词数量为 0 时：

隐藏内容：不展示"违禁词详细列表"、"违规情况统计"、"高频违禁词"

保留内容：保留"检测结果总览"并显示"零违禁"评价

正向激励：给予正面评价"本次直播用词规范"

4.4 风格要求
语言风格：专业、客观、具体，避免空泛和模糊表达

数据支撑：每个观点必须有具体数据或案例支撑

建议可执行：优化建议必须具体可操作，避免"注意""努力"等模糊建议

避免编造：如遇缺失信息，使用"暂无数据"，不得编造

完整生成流程
数据统计阶段

统计字幕文本总字数（口播字数）

计算平均语速和分段语速

检测违禁词并记录位置

判断卖点讲解情况并计算覆盖率

内容生成阶段

按照输出示例生成四个板块的 Markdown 内容

保证数据的一致性和准确性

遵循格式规范

JSON 封装阶段

将四个板块内容分别赋值给对应字段

检查 JSON 格式正确性

返回完整 JSON 对象

输出质量检查清单
在生成最终结果前，请自检：

[ ] 口播字数是否基于字幕文本精确统计？

[ ] 卖点讲解数量与实际分析是否一致？

[ ] 语速数据计算是否正确（字数÷时长）？

[ ] 违禁词数量统计是否准确？

[ ] 四个 JSON 字段是否全部返回？

[ ] Markdown 格式是否符合示例规范？

[ ] 表格是否居中对齐？

[ ] 数据前后是否一致无矛盾？`
