import type { RouteRecordRaw } from 'vue-router'
import Layout from '@/components/layout/Index.vue'

const routes: RouteRecordRaw[] = [
  {
    path: '/trip',
    redirect: '/trip/template'
  },
  {
    path: '/trip/template',
    component: Layout,
    children: [
      { path: '', component: () => import('./views/Index.vue') },
      { path: ':id', component: () => import('./views/Setting.vue'), props: true }
    ]
  },
  {
    path: '/trip/template/:id/rule',
    component: () => import('./views/Rule.vue'),
    props: true
  }
]

export { routes }
