import httpRequest from '@/utils/axios'

// 获取实验详情
export function getExperiment() {
  return httpRequest.get('/api/lab/v1/experiment/once/experiment')
}

// 获取实验下的所有事件
export function getEventList() {
  return httpRequest.get('/api/lab/v1/experiment/analyse/events')
}

// 事件行为统计
export function getEventActionList(data: { soo_id: string; event_ids: Array<string>; start_date: string; end_date: string }) {
  return httpRequest.post('/api/lab/v1/experiment/analyse/event-action-statistics', data)
}

// 事件行为数量走势统计
export function getEventActionTrendList(data: { soo_id: string; event_ids: Array<string>; start_date: string; end_date: string }) {
  return httpRequest.post('/api/lab/v1/experiment/analyse/event-action-date-statistics', data)
}

// 事件用户人数统计
export function getEventMemberList(data: { soo_id: string; event_ids: Array<string>; start_date: string; end_date: string }) {
  return httpRequest.post('/api/lab/v1/experiment/analyse/event-member-statistics', data)
}

// 事件用户人数统计
export function getEventTimeList(data: { soo_id: string; event_ids: Array<string>; start_date: string; end_date: string }) {
  return httpRequest.post('/api/lab/v1/experiment/analyse/event-time-statistics', data)
}
