export const generateCommodityTypePrompt = (data: any) => {
  return `请根据选手提交的商品品类信息进行评分（满分3分）：
选手提交内容：
${JSON.stringify(data.commodity_types)}

评分规则

一级品类创建（2分）

判定标准：
1.必须创建三个一级品类：速食面品类、鲜切面品类、调料配菜品类
2.状态必须为"有效"

计分规则：
●全部满足：2分
●缺少1个一级品类：扣1分
●状态非"有效"：扣0.5分
●扣分可累计，最低0分

二级品类创建（1分）

判定标准：

速食面品类下：
●至少2个二级品类
●必须包含：“复合式速煮面”、“高端速食拌面/干面”
●状态为"有效"

鲜切面品类下：
●至少2个二级品类
●必须包含：“生鲜手擀/拉面”、“地方特色鲜面”
●状态为"有效"

调料配菜品类下：
●至少2个二级品类
●必须包含：“复合调味料包”、“即食真材配菜”
●状态为"有效"

计分规则：

●每个一级品类下必选项齐全且状态正确：+0.33分（共1分）
●必选项缺失：每项-0.1分
●状态非"有效"：每处-0.05分
●明显不合理命名：每处-0.05分
●扣分可累计，最低0分

【整体评价】
（请对选手整体表现进行1-2句总结性评价）`
}

export const generateCommodityAttrsPrompt = (data: any) => {
  return `
请根据选手提交的商品属性配置进行评分（满分2分）：

选手提交内容：
${JSON.stringify(data.commodity_attrs)}

评分规则

速食面品类属性（1分）
必须包含且名称合理的5项属性：
1.产品规格
2.口味类型
3.辣度等级
4.保质期
5.烹饪时长

计分规则：
●每项0.2分
●存在且名称合理即得分，不存在或名称不合理即0分
●不设部分分
●同义词、近似表达不计分（如"容量"不等于"产品规格"）

鲜切面品类属性（0.5分）
必须包含且名称合理的5项属性：
1.产品规格
2.面条类型
3.保存方式
4.保质期
5.适合人数

计分规则：
●每项0.1分
●存在且名称合理即得分，不存在或名称不合理即0分
●不设部分分
●同义词、近似表达不计分

调料配菜品类属性（0.5分）
必须包含且名称合理的5项属性：
1.产品规格
2.配料成分
3.辣度等级
4.保质期
5.适用场景

计分规则：

●每项0.1分
●存在且名称合理即得分，不存在或名称不合理即0分
●不设部分分
●同义词、近似表达不计分

判定说明
1.精确匹配原则：本模块计分以"属性名是否存在且名称合理"作为依据
2.同义词处理：同义词、近似表达不计分（如"容量"不等于"产品规格"）
3.其他字段：重要性、必要性、状态设置是否合理不影响本模块计分，但可在评价中提及`
}

export const generateCommoditiesPrompt = (data: any) => {
  return `
请根据选手提交的商品信息维护内容进行评分（满分10分）

选手提交内容:
${JSON.stringify(data.commodities)}

评分规则

1. 商品类目关联（1分）
判定标准：
●一级品类判定：
○"襄阳牛肉面2桶装（有牛肉）"应关联到"速食面品类"一级品类
●二级品类判定：
○应关联到"速食面品类"下的“复合式速煮面”二级品类

计分规则：
●同时正确关联一级品类和二级品类：1分
●只关联一级品类或只关联二级品类：0.5分
●错误或缺失：0分

2. 商品主图（2分）
判定标准：
●每个商品至少2张1:1比例主图
●仅以张数为准，不要求质量

计分规则：
●满足2张及以上1:1主图：2分
●只有1张：-1分（得1分）
●不足1张：-2分（得0分）

3. 3:4比例主图（1分）
判定标准：
●每个商品至少1张3:4比例主图
●仅以张数为准，不要求质量

计分规则：
●满足要求：1分
●否则：0分

4. 价格库存配置（4分）
判定标准与计分：
商品的规格、价格、库存、发货设置等信息配置完整准确。
●包含：价格、参考价、库存数量；每缺一要素-1分
●发货模式：必须为"现货发货"；不符合-1分
●扣分累计，但本项最低0分

5. 服务履约配置（2分）
判定标准与计分：
●运费模板：从以下选项中任选一项即可得分：阶梯计价运费、固定运费、卖家包邮、指定条件包邮、限制买家下单区域、按件数计价、按重量计价、指定地区运费；缺失-1分。
●售后政策：从以下选项中任选一项即可得分：7天无理由退换货、全额退款、仅退款政策、预付邮费标签、全球购物保障计划、无忧退换货、闪电退货、售后补寄；缺失-1分。
●扣分累计，但本项最低0分

【整体评价】
（请对选手整体表现进行1-2句总结性评价）`
}

export const generateSpeechPrompt = (data: any) => {
  return `
请根据选手提交的直播话术进行评分（满分15分）

选手提交内容内容：
${JSON.stringify(data.speeches)}

评分规则
1. 直播话术名称（3分）
判定标准：
●5-20字
●主题明确，体现直播主题

计分规则：
●符合要求：3分
●不符合：-1.5分（得1.5分）

2. 直播主题卖点（3分）
判定标准：
●每个商品≥3个核心卖点
●具体有说服力
●针对目标用户痛点

计分规则：
●每缺1个卖点：-1分
●描述空泛：每处-0.5分（上限-1分）
●扣分累计，最低0分

3. 营销活动设计（3分）
判定标准：
●至少3个活动
●活动形式多样化
●优惠力度合理
●必须包含：限时秒杀活动、组合优惠活动、互动抽奖活动

计分规则：
●不足3个活动：-1分
●缺1类必选活动：-1分
●规则不清：-0.5分
●扣分累计，最低0分

4. 直播话术脚本撰写（4分）
必须包含以下环节，缺环节-0.5分/项：
1.开场白环节：热情问候、主题引入、福利预告、引导关注
2.品牌介绍环节：品牌故事、品牌实力、产品线介绍
3.主推产品讲解环节：产品展示、成分讲解、卖点阐述、使用场景、案例分享、价格优惠、促单话术
4.互动环节：回应评论、互动问答、抽奖活动
5.促销推动环节：强调组合优惠、满额包邮、催单话术
6.结束语环节：总结要点、感谢支持、预告下播、最后提醒

话术质量要求：
●语言自然流畅，口语化表达
●逻辑清晰，节奏合理
●卖点讲解充分，有说服力
●互动环节设计合理，能调动氛围
●促销话术到位，但不过度推销
●无违禁词

常见违禁词快速对照表
类别1：绝对化用语（共20个）
最、最佳、最好、最优、最大、最小、最新、最先进
第一、首个、首选、唯一、独一无二、前无古人
极致、完美、顶级、至尊、终极、巅峰

类别2：夸大宣传（共15个）
100%、百分百、保证、必然、绝对、肯定
立竿见影、立即见效、马上见效、即刻
永久、终身、永远、一劳永逸、彻底

类别3：医疗用语（共20个）
治疗、治愈、医治、疗效、药用、处方
抗炎、消炎、杀菌、灭菌、防癌、抗癌
降血压、降血糖、降血脂、治痤疮、祛痘、去斑
修复、再生（需谨慎使用）

类别4：虚假宣传（共10个）
国家级、世界级、全球级、宇宙级
最高级、最低价、史无前例、前所未有
销量第一、市场占有率第一

计分规则：
●缺环节：-0.5分/项
●明显质量问题：每处-0.5分
●扣分累计，最低0分

5. 时长设置（2分）
判定标准：
●设置为15分钟
●时间分配合理（重点突出、互动穿插）

计分规则：
●符合要求：2分
●未设置或明显不合理：0分

【整体评价】
（请对选手话术整体质量进行1-2句总结性评价）`
}

export const generatePracticeRecordPrompt = (data: any) => {
  const firstLivePractice = data.practices[0]
  const firstLivePracticeRecord = firstLivePractice?.records[0]
  return `请根据选手提交的内容进行评分（满分15分）
选手提交内容：
  ${JSON.stringify(firstLivePracticeRecord)}

评分规则
1. 开场与氛围营造（2分）
判定标准：
●开场白吸引人
●快速进入状态
●营造良好直播氛围

计分规则：
●符合要求：2分
●表现一般：-1分（得1分）
●表现不足：-2分（得0分）

2. 商品讲解能力（3分）
判定标准：
●商品介绍清晰准确
●重点突出
●讲解有说服力

计分规则：
●符合要求：3分
●表现一般：-1.5分（得1.5分）
●表现不足：-3分（得0分）

3. 互动回应能力（2分）
判定标准：
●及时回应观众评论和问题
●互动自然流畅

计分规则：
●符合要求：2分
●表现一般：-1分（得1分）
●表现不足：-2分（得0分）

4. 促销引导能力（2分）
判定标准：
●有效引导观众关注、点赞、下单
●转化技巧运用得当
计分规则：
●符合要求：2分
●表现一般：-1分（得1分）
●表现不足：-2分（得0分）

5. 语言表达与形象（4分）
判定标准：
●普通话标准
●语速适中（理想区间：180-220字/分钟）
●表情自然
●形象得体
计分规则：
●全部符合：4分
●语速偏离：-1分
●普通话不标准：-1分
●表情不自然：-1分
●形象不得体：-1分
●扣分累计，最低0分
语速标准参考
理想语速：180-220 字/分钟
- 观众能够轻松跟上
- 有足够时间理解信息
- 节奏舒适，不紧不慢
偏快语速：221-240 字/分钟
- 部分观众可能跟不上
- 影响信息吸收效果
- 建议适当放慢
过快语速：>240 字/分钟
- 大部分观众难以跟上
- 严重影响直播效果
- 必须改进
偏慢语速：150-179 字/分钟
- 节奏稍显拖沓
- 可能影响直播间活跃度
- 建议适当加快
过慢语速：<150 字/分钟
- 节奏过于拖沓
- 观众容易失去耐心
- 必须改进

6. 内容合规性（2分）
判定标准：
●严格遵守《网络主播行为规范》
●无违规内容
●无违禁词

计分规则：
●完全合规：2分
●有轻微违规：-1分（得1分）
●有明显违规：-2分（得0分）
《网络主播行为规范》31项禁止行为（重点摘要）：
（一）政治与意识形态类
1.恶搞、歪曲、丑化党和国家形象；
2.散布谣言、煽动颠覆国家政权、分裂国家领土；
3.宣传封建迷信、邪教、恐怖主义等内容。
（二）低俗庸俗类
1.展示淫秽、色情、暴力、血腥画面；
2.着装暴露、动作挑逗、打“擦边球”；
3.使用粗俗语言、侮辱性词汇、地域歧视等。
（三）虚假宣传与消费误导类
1.虚假宣传商品功效、产地、成分、质量；
2.使用“国家级”“最优惠”“第一品牌”等绝对化用语；
3.伪造销量、用户评价、直播间人气；
4.谎称“最后X件”“仅限今天”制造抢购氛围；
5.诱导未成年人非理性消费或打赏；
6.未标明广告属性，以“自用推荐”名义进行商业推广。
（四）知识产权与版权类
1.未经授权播放音乐、影视、游戏画面；
2.盗用他人直播内容、脚本、创意；
3.使用他人肖像、声音、商标未经许可。
（五）食品安全与健康风险类
1.无资质宣传医疗、药品、保健食品功效；
2.推荐“三无产品”、过期食品、违禁品；
3.试吃来源不明、无检验合格证明的食品；
4.宣称普通食品具有“治疗疾病”“增强免疫力”等医疗效果。
（六）其他违规行为
1.酒后直播、醉酒状态出镜；
2.直播赌博、诈骗、传销等活动；
3.泄露他人隐私、个人信息；
4.冒充专家、医生、律师等专业人士；
5.恶意炒作、拉踩同行、制造对立；
6.在公共场所直播影响公共秩序；
7.利用直播进行非法集资、金融诈骗；
8.传播伪科学、反智言论；
9.侵犯消费者合法权益（如不退不换、虚假售后）；
10.不配合平台或监管部门调查；
11.未取得相关资质从事特定领域直播（如医疗、教育、金融）；
12.其他违反法律法规及公序良俗的行为。
特别针对“电商/带货主播”的强化要求
1.商品审核义务
○主播应对所售商品基本信息（成分、产地、保质期、适用人群）进行核实；
○不得为“三无产品”、假冒伪劣、违禁品带货。
1.广告标识义务
○凡涉及商业推广的内容，应明确标注“广告”“推广”字样；
○不得以“自用推荐”“朋友家产品”等模糊方式规避广告责任。
1.售后与责任承担
○若主播以自身名义推荐商品（如“XX严选”“主播同款”），可能被认定为广告代言人，需对产品质量承担连带责任；
○应配合平台处理消费者投诉，不得推诿、搪塞。
1.数据真实性
○禁止刷单、刷评、虚构交易额、观看量；
○平台将对异常数据进行监测并处罚。`
}

export const generateImprovementPlanPrompt = (data: any) => {
  const firstLivePractice = data.practices[0]
  const firstLivePracticeRecord = firstLivePractice?.records[0]
  return `请根据选手提交的改进方案进行评分（满分10分）：
选手提交的改进方案：
  ${JSON.stringify(firstLivePracticeRecord?.improvement_plan)}
评分规则
1. 改进方案数量（10分）
判定标准：
1.数量要求：至少5条具体的改进措施
2.内容要求：每条改进措施必须包括：
○问题描述
○改进目标
○改进方法
1.维度要求：改进方案需涵盖语速、违禁词、卖点讲解、互动、促销等多个维度
计分规则：
●不足5条：每缺1条-2分
●每条改进措施缺少三要素之一：每处-0.5分
●未覆盖多维度：-1分
●扣分累计，但本项最低0分`
}

export const generatePracticeRecord2Prompt = (data: any) => {
  const secondLivePractice = data.practices[1]
  const secondLivePracticeRecord = secondLivePractice?.records[0]
  return `
请根据选手提交的二次直播演练内容进行评分（满分30分）
选手提交内容：
  ${JSON.stringify(secondLivePracticeRecord)}
评分说明
以改进方案列出的措施和首次直播AI评价报告中的问题为基准，逐条对照二次直播字幕/话术确认改进落实与否。

评分规则
1. 话术与表现优化（5分）
判定标准：
●话术修改到位
●删除所有违禁词
●补充遗漏卖点

计分规则：
●完全符合：5分
●部分符合：-2.5分（得2.5分）
●不符合：-5分（得0分）

2. 直播完成度（2分）
判定标准：
●完成完整的二次直播流程
●时长符合要求（15分钟，±5%）

计分规则：
●符合要求：2分
●不达标：-2分（得0分）

3. 语速控制改进（6分）
判定标准：
●平均语速控制在180-220字/分钟
●相比首次直播有明显改善

计分规则：
●达标且较首次优化显著：6分
●仅达标无改善：-2分（得4分）
●未达标：-3分（得3分）

语速标准参考

理想语速：180-220 字/分钟
- 观众能够轻松跟上
- 有足够时间理解信息
- 节奏舒适，不紧不慢
偏快语速：221-240 字/分钟
- 部分观众可能跟不上
- 影响信息吸收效果
- 建议适当放慢
过快语速：>240 字/分钟
- 大部分观众难以跟上
- 严重影响直播效果
- 必须改进
偏慢语速：150-179 字/分钟
- 节奏稍显拖沓
- 可能影响直播间活跃度
- 建议适当加快
过慢语速：<150 字/分钟
- 节奏过于拖沓
- 观众容易失去耐心
- 必须改进

4. 违禁词改进（5分）
判定标准：
●二次直播零违禁词
●所有表达符合平台规范
计分规则：
●零违禁词：5分
●若仍出现违禁词：直接0分，并记录违禁词
常见违禁词快速对照表
类别1：绝对化用语（共20个）
最、最佳、最好、最优、最大、最小、最新、最先进
第一、首个、首选、唯一、独一无二、前无古人
极致、完美、顶级、至尊、终极、巅峰

类别2：夸大宣传（共15个）
100%、百分百、保证、必然、绝对、肯定
立竿见影、立即见效、马上见效、即刻
永久、终身、永远、一劳永逸、彻底

类别3：医疗用语（共20个）
治疗、治愈、医治、疗效、药用、处方
抗炎、消炎、杀菌、灭菌、防癌、抗癌
降血压、降血糖、降血脂、治痤疮、祛痘、去斑
修复、再生（需谨慎使用）

类别4：虚假宣传（共10个）
国家级、世界级、全球级、宇宙级
最高级、最低价、史无前例、前所未有
销量第一、市场占有率第一

5. 卖点覆盖改进（3分）
判定标准：
●所有商品卖点覆盖率达到100%
●相比首次直播有提升

计分规则：
●覆盖率达到100%且较首次提升：3分
●缺失：-1.5分（得1.5分）
●无提升：-1分（得2分）

6. 互动技巧改进（3分）
判定标准：
●互动频次提升
●互动方式多样
●相比首次直播有明显提升

计分规则：
●符合要求且较首次提升：3分
●无提升：-1.5分（得1.5分）
●不足：-2分（得1分）

7. 促销话术改进（3分）
判定标准：
●促销话术更加自然真诚
●紧迫感营造到位
●相比首次直播有改进

计分规则：
●符合要求且较首次提升：3分
●无提升：-1.5分（得1.5分）
●明显不足：-2分（得1分）

8. 整体表现提升（3分）
判定标准：
●语言表达、状态自信度、节奏把控等整体表现有显著提升
●结合改进方案落实情况说明证据
计分规则：
●符合要求且有证据支撑：3分
●证据不足：-1.5分（得1.5分）
●无明显提升：-2分（得1分）
`
}

export const generateReportPrompt = (data: any) => {
  return `请根据选手提交的直播总结报告进行评分（满分10分）
选手提交内容：
  ${JSON.stringify(data.reports)}
  `
}

export const generatePrompt = (data: any) => {
  return `
  ${generateCommodityTypePrompt(data)}
  ${generateCommodityAttrsPrompt(data)}
  ${generateCommoditiesPrompt(data)}
  ${generateSpeechPrompt(data)}
  ${generatePracticeRecordPrompt(data)}
  ${generateImprovementPlanPrompt(data)}
  ${generateReportPrompt(data)}
EXAMPLE JSON OUTPUT:
{
  "commodity_type": {
    "score": 5,
    "comment": "这是评语"
  },
  "commodity_attr": {
    "score": 5,
    "comment": "这是评语"
  },
  "commodity": {
    "score": 5,
    "comment": "这是评语"
  },
  "speech": {
    "score": 5,
    "comment": "这是评语"
  },
  "practice_record1": {
    "score": 5,
    "comment": "这是评语"
  },
  "improvement_plan": {
    "score": 5,
    "comment": "这是评语"
  },
  "practice_record2": {
    "score": 5,
    "comment": "这是评语"
  },
  "report": {
    "score": 5,
    "comment": "这是评语"
  },
}
`
}
