import { useWebSocket, type UseWebSocketOptions } from '@vueuse/core'
import { useUserStore } from '@/stores/user'

export function useSocket(options: UseWebSocketOptions) {
  const userStore = useUserStore()
  const ssoId = userStore.user?.id
  const defaultOptions = {
    autoReconnect: true,
    onConnected: () => {
      send(JSON.stringify({ type: 'login', sso_id: ssoId }))
    },
    heartbeat: { message: JSON.stringify({ type: 'health', sso_id: ssoId }), interval: 1000 * 50, pongTimeout: 1000 },
  }

  const { status, data, send, open, close } = useWebSocket('wss://saas-lab-api.ezijing.com/wss', {
    ...defaultOptions,
    ...options,
  })

  return { status, data, send, open, close }
}
